# Direct workflow
# http://wiki.yandex-team.ru/Direkt/dostup/ReglamentpredostavlenijadostupakDirektunovyjj/MatricarolejjDirekt/.old?time=2013-01-09+11:24:58
# актуальная матрица https://wiki.yandex-team.ru/direct/dostup/matrica-rolejj-direkta2022/


# эта переменная будет содержать дополнительные поля,
# такие, как passport-login
additional_fields = {}
additional_fields.update(fields_data or {})
additional_fields.update(system_specific or {})


if user.department_group is None:
    raise AccessDenied('Нет информации об отделе. Необходимо дождаться синхронизации со стаффом.')

# ускоряем обработку роли support_for_client: DIRECT-157898
if role == {'direct': u'support_for_client'}:  # саппорт с доступом к клиенту
    if requester.username == 'robot-crm' or reason == RUN_REASON.REREQUEST:
        approvers = []
        no_email = True
    else:
       approvers = [approver('anyksenya', priority=1) | approver('dmsuvorov', priority=1)]
    raise Return()


def has_role(user, role_slug, passport_login):
    """Проверяет что у сотрудника есть роль на заданном паспортном логине.
        Пример использования:

        if has_role(user, 'teamleader', 'tor-aiden2'):
            approvers = []

        В этом примере мы проверяем, есть ли роль teamleader у сотрудника, которому выдается роль, на внешнем логине tor-aiden2.
    """
    return user.has_role(
        {'direct': role_slug},
        system_specific={'passport-login': passport_login}
    )


def has_balance_role(user):
    """
    При запросе роли "менеджер" проверяем, что есть одна из этих ролей в Балансе
    - Менеджер клиентского отдела {'role': '1'}
    - Менеджер агенского отдела {'role': '10'}
    - Саппорт сервисов {'role': '9'}
    - Менеджер клиенского отдела+создание клиента {'role': '21'}
    - Менеджер коммерческого департамента {'role': '10175'}
    """
    return user.has_role({'role': '1'}, system='balance') or \
           user.has_role({'role': '10'}, system='balance') or \
           user.has_role({'role': '9'}, system='balance') or \
           user.has_role({'role': '21'}, system='balance') or \
           user.has_role({'role': '10175'}, system='balance')


def get_boss(user):
    return user.get_chain_of_heads(up_to_level=-2, priority_policy='equal')


def get_security():
    security_team = groupify(147721).members
    return any_from(security_team, priority=1)

def get_internal_ad_team():
    internal_ad_team = groupify('yandex_mrkt_market_adv').members
    return any_from(internal_ad_team, priority=1)


def works_in_sales(user): # Департамент Продаж и Продажи SMB
    return user.works_in_dep('yandex_biz_com_dep14655', 'yandex_content_7382')


def check_for_conflict_roles():
    """
    Не даём запрашивать вторую базовую роль на тот же логин
    """
    # Список базовых ролей. На один логин можем выдать только одну базовую роль
    base_roles = ['developer', 'internal_ad_admin', 'internal_ad_manager', 'internal_ad_superreader', 'limited_support',
            'manager', 'media', 'placer', 'super', 'superreader', 'support']
    def existing_role_on_same_login(user, passport_login):
        for role in base_roles:
            if has_role(user, role, passport_login):
                return role
        return None
    
    direct_role = role['direct']
    if direct_role in base_roles:
        passport_login = additional_fields.get('passport-login')
        existing_role = existing_role_on_same_login(user, passport_login)
        if existing_role is not None and existing_role != direct_role:
            raise AccessDenied(u'Логин {passport_login} уже имеет в Директе роль {existing_role}. Пожалуйста, используйте другой логин'
                .format(passport_login=passport_login, existing_role=existing_role))
check_for_conflict_roles()

# Базовые проверки прошли успешно, формируем список подтверждающих
approvers = None

if role == {'direct': u'main_manager_for_client'}:  # назначение "Главного менеджера" через ABC
    if requester.username in ['zomb-prj-282', '2012190'] or reason == RUN_REASON.REREQUEST:
        approvers = []
        no_email = True
    else:
        raise AccessDenied(u'Роль "%s" можно получить только из ABC' % (role))

elif role == {'direct': u'superteamleader'}:  # начальник отдела
    if works_in_sales(user):
        # Участникам этих групп выдаём роль с апрува руководителя
        approvers = [get_boss(user)]
    else:
        approvers = [get_boss(user), any_from(['anyksenya', 'dmsuvorov'], priority=1)]

elif role == {'direct': u'teamleader'}:  # тимлидер
    if works_in_sales(user):
        # Участникам этих групп выдаём роль с апрува руководителя
        approvers = [get_boss(user)]
    else:
        approvers = [get_boss(user), any_from(['anyksenya', 'dmsuvorov'], priority=1)]

elif role == {'direct': u'manager'}:  # менеджер
    # участник команды "Сектор асессоров-медиапланеров"
    is_mediaplanner = user.works_in_dep('as_dep19389')

    skip_balance_role_check = requester.username in ('anyksenya', 'dmsuvorov') or is_mediaplanner
    if not skip_balance_role_check:
        if not has_balance_role(user):
            raise AccessDenied(
                u'Для запроса роли "менеджер" нужно получить роль "Менеджер клиентского сервиса" в Балансе')
    if (has_role(user, 'teamleader', additional_fields.get('passport-login')) or
        has_role(user, 'superteamleader', additional_fields.get('passport-login'))
        ):
        # Если есть роль руководителя группы или отдела, не требуем апрува на роль "менеджер" -- де-факто она и так есть
        approvers = []
    elif works_in_sales(user) or is_mediaplanner:
        # Участникам этих групп выдаём роль с апрува руководителя
        approvers = [get_boss(user)]
    else:
        approvers = [any_from(['anyksenya', 'dmsuvorov'], priority=1)]

elif role == {'direct': u'internal_ad_admin'}:  # администратор внутренней рекламы
    if user.works_in_dep('yandex_mrkt_market_adv'):
        approvers = []
    else:
        approvers = [
            get_internal_ad_team() | any_from(['anyksenya', 'dmsuvorov'], priority=2)]

elif role == {'direct': u'internal_ad_manager'} or role == {'direct': u'internal_ad_superreader'}:  # менеджер или суперсмотритель внутренней рекламы
    if requester.works_in_dep('yandex_mrkt_market_adv'):
        approvers = []
    else:
        approvers = [
            get_internal_ad_team() | any_from(['anyksenya', 'dmsuvorov'], priority=2)]

elif role == {'direct': u'support'}:  # саппорт
    if user.works_in_dep(
        'yandex_biz_com_supp_comserv_product_8839_1506',
    ):
        approvers = [get_boss(user)]
    else:
        approvers = [get_boss(user), any_from(['anyksenya', 'dmsuvorov'], priority=1), get_security()]

elif role == {'direct': u'limited_support'}:  # саппорт с ограниченным доступом
    if user.works_in_dep('yandex_biz_com_supp_comserv_dep52699',
                         'yandex_content_7382'):
        approvers = [get_boss(user)]
    else:
        approvers = [get_boss(user) | any_from(['anyksenya', 'dmsuvorov'], priority=2)]

elif role == {'direct': u'media'}:  # медиапланер
    ref_roles = [{
        'system': 'metrika',
        'role_data': {'metrika': 'manager_direct'},
        'role_fields': {'passport-login': (fields_data or system_specific).get('passport-login')}
    }]

    if user.works_in_dep('yandex_biz_com_dep74191_dep50093'):
        approvers = [get_boss(user)]
    else:
        approvers = [get_boss(user), any_from(['anyksenya', 'dmsuvorov'], priority=1), get_security()]

elif role == {'direct': u'placer'}:  # вешальщик
    ref_roles = [{
        'system': 'metrika',
        'role_data': {'metrika': 'manager_direct'},
        'role_fields': {'passport-login': (fields_data or system_specific).get('passport-login')}
    }]

    if user.works_in_dep('yandex_search_tech_assesment_toloka_dep14856_dep19832'):
        approvers = [get_boss(user)]
    else:
        approvers = [get_boss(user), any_from(['anyksenya', 'dmsuvorov'], priority=1), get_security()]

elif role == {'direct': u'super'}:  # супер-пользователь
    ref_roles = [{
        'system': 'metrika',
        'role_data': {'metrika': 'manager_direct'},
        'role_fields': {'passport-login': (fields_data or system_specific).get('passport-login')}
    }]

    approvers = [get_boss(user), any_from(['anyksenya', 'dmsuvorov'], priority=1), get_security()]

elif role == {'direct': u'superreader'}:  # суперсмотритель
    ref_roles = [{
        'system': 'metrika',
        'role_data': {'metrika': 'manager_direct'},
        'role_fields': {'passport-login': (fields_data or system_specific).get('passport-login')}
    }]

    if user.works_in_dep('yandex_monetize',
                         'yandex_biz_com',
                         'yandex_search_tech_sq_analysis_dep72847'):
        approvers = [get_boss(user), any_from(['anyksenya', 'dmsuvorov'], priority=1)]
    else:        
        approvers = [get_boss(user), any_from(['anyksenya', 'dmsuvorov'], priority=1), get_security()]

elif role == {'direct': u'developer'}:  # разработчик
    ref_roles = [{
        'system': 'metrika',
        'role_data': {'metrika': 'manager_direct'},
        'role_fields': {'passport-login': (fields_data or system_specific).get('passport-login')}
    }]

    if user.works_in_dep('yandex_monetize_search_direct_interface_dep16266',
                         'yandex_monetize_tech_dev_dep79329'):
        approvers = [get_boss(user)]
    else:        
        approvers = [get_boss(user), any_from(['anyksenya', 'dmsuvorov'], priority=1), get_security()]

elif role == {'direct': u'manager_for_client'}:  # групповой доступ менеджеров к клиенту или агентству
    raise AccessDenied(u'Роль "менеджер с доступом к клиенту" необходимо выдавать на группу')


