import logging
import os

# from direct.infra.warden_stuff.migrations.DIRECT_146847 import move_db_alerts_to_separate_vertical
from direct.infra.warden_stuff.migrations.DIRECT_166174 import combine_ppcdata_functionalities
from search.mon.warden.proto.structures.component_pb2 import GetComponentRequest
from search.mon.warden.services.warden import WardenClient


def main():
    tune_logging()
    client = create_client()
    # debug(client)
    combine_ppcdata_functionalities(client)


def debug(client: WardenClient):
    component = client.get_component(GetComponentRequest(name="direct")).component
    functionalities = {f.id: f.name for f in component.functionality_list}

    logging.info(functionalities)
    logging.info(component.functionality_list[0])


def create_client():
    token = os.environ.get('WARDEN_OAUTH')
    if token is None:
        raise Exception("No WARDEN_OAUTH token in env")
    client = WardenClient.from_address('warden.z.yandex-team.ru', credentials=token)
    return client


def tune_logging():
    logging.basicConfig(level=logging.INFO, format='%(asctime)-15s %(levelname)s [%(process)s] %(message)s')
    for lib in ("martylib.trace",
                ):
        logging.getLogger(lib).setLevel(level=logging.WARN)


if __name__ == "__main__":
    main()
