import logging

from search.mon.warden.proto.structures.component_pb2 import GetComponentRequest
from search.mon.warden.proto.structures.functionality_pb2 import Functionality, UpdateFunctionalityRequest
from search.mon.warden.services.warden import WardenClient

NEW_SERVICE = "db-mysql"
logger = logging.getLogger('migration')


def move_db_alerts_to_separate_vertical(client: WardenClient):
    logger.debug("fetch component")
    component = client.get_component(GetComponentRequest(name="direct")).component
    func: Functionality
    for func in component.functionality_list:
        if not func.name.startswith("db_availability"):
            logger.debug("skip functionality %s — %s", func.id, func.name)
            continue

        func.name = func.name.replace("db_availability", "availability")
        func.slug = "_".join(("direct", NEW_SERVICE, func.name))

        logging.info("update functionality: %s (%s)", func.id, func.name)

        update_request = UpdateFunctionalityRequest(functionality=func, service_name=NEW_SERVICE)
        client.update_functionality(update_request)
