import logging

from search.mon.warden.proto.structures.component_pb2 import GetComponentRequest
from search.mon.warden.proto.structures.functionality_pb2 import Functionality, DeleteFunctionalityRequest, UpdateFunctionalityRequest
from search.mon.warden.services.warden import WardenClient

SERVICE = "db-mysql"
logger = logging.getLogger('migration')


def combine_ppcdata_functionalities(client: WardenClient):
    dbComponent = client.get_component(GetComponentRequest(name=SERVICE, parent_component_name="direct")).component
    curFunc : Functionality
    for curFunc in dbComponent.functionality_list:
        if not curFunc.name.startswith("availability_ppcdata"):
            logger.info("skip functionality %s (%s)", curFunc.name, curFunc.id)
            continue
        if curFunc.name == "availability_ppcdata1":
            curFunc.name = "availability_ppcdata"
            curFunc.description = "Доступность шардов ppcdata"
            curFunc.slug = "direct_db-mysql_availability_ppcdata"
            curFunc.weight = 0.0
            logger.info("rename functionality %s to %s, change weight to 0", curFunc.id, curFunc.name)
            client.update_functionality(UpdateFunctionalityRequest(
                functionality=curFunc,
                service_name=SERVICE,
                comment="считаем основной ppcdata1",
                ))
        else:
            logger.info("delete functionality %s (%s)", curFunc.name, curFunc.id)
            client.delete_functionality(
                request=DeleteFunctionalityRequest(functionality_id=curFunc.id),
                timeout=10.0)
