package ru.yandex.direct.intapi;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
public class ErrorResponse {
    private final ErrorCode code;
    private final String message;

    @JsonCreator
    public ErrorResponse(@JsonProperty("code") ErrorCode code, @JsonProperty("message") String message) {
        this.code = code;
        this.message = message;
    }

    @ApiModelProperty(
            value = "код ошибки",
            required = true
    )
    public ErrorCode getCode() {
        return code;
    }

    @ApiModelProperty(
            value = "причина ошибки",
            required = true
    )
    public String getMessage() {
        return message;
    }

    public enum ErrorCode {
        PERMISSION_DENIED,
        BAD_PARAM,
        INTERNAL_ERROR,
        NOT_FOUND,
        TOO_MANY_REQUESTS
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ErrorResponse response = (ErrorResponse) o;
        return code == response.code &&
                Objects.equals(message, response.message);
    }

    @Override
    public int hashCode() {
        return Objects.hash(code, message);
    }
}
