package ru.yandex.direct.intapi;

import org.springframework.http.HttpStatus;

import ru.yandex.direct.utils.JsonUtils;

public class IntApiException extends RuntimeException {
    private final HttpStatus httpStatus;
    private final Object errorObject;

    public IntApiException(HttpStatus httpStatus, Object errorObject) {
        this.httpStatus = httpStatus;
        this.errorObject = errorObject;
    }

    public IntApiException(HttpStatus httpStatus, String message, Object... params) {
        this.httpStatus = httpStatus;
        this.errorObject = String.format(message, params);
    }

    public HttpStatus getHttpStatus() {
        return httpStatus;
    }

    public Object getErrorObject() {
        return errorObject;
    }

    @Override
    public String getMessage() {
        return JsonUtils.toJson(errorObject);
    }
}
