package ru.yandex.direct.intapi;

import org.slf4j.Logger;

import ru.yandex.direct.common.jetty.JettyConfig;
import ru.yandex.direct.common.jetty.JettyLauncher;
import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.config.DirectConfigFactory;
import ru.yandex.direct.jcommander.ParserWithHelp;
import ru.yandex.direct.logging.LoggingInitializer;
import ru.yandex.direct.logging.LoggingInitializerParams;

public class IntapiApp {
    private static final Logger logger = LoggingInitializer.getLogger(IntapiApp.class);

    private IntapiApp() {
        // deny instantiation
    }

    public static void main(String[] args) throws Exception {
        LoggingInitializerParams loggingParams = new LoggingInitializerParams();
        ParserWithHelp.parse(IntapiApp.class.getCanonicalName(), args, loggingParams);
        LoggingInitializer.initialize(loggingParams, "direct.intapi");

        DirectConfig conf = DirectConfigFactory.getConfig();

        JettyConfig jettyConfig = new JettyConfig(conf.getBranch("jetty"));

        logger.info("start jetty server with config: {}", jettyConfig);
        logger.info("check http://{}:{}/docs/ for swagger built-in documentation",
                jettyConfig.host == null ? "localhost" : jettyConfig.host, jettyConfig.port);

        JettyLauncher.server(jettyConfig)
                .withDefaultWebApp(IntapiApp.class.getClassLoader(), "/")
                .run();
    }
}
