package ru.yandex.direct.intapi.common.converter;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefectPresentationRegistry;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;

import static org.apache.commons.lang.StringUtils.EMPTY;

public class DefectsConverter {
    private DefectsConverter() {
    }

    public static String defectsToString(
            TranslationService translationService,
            DefectPresentationRegistry<TranslatableIntapiDefect> defectPresentationRegistry,
            List<DefectInfo<Defect>> defectInfos) {
        if (defectInfos.isEmpty()) {
            return EMPTY;
        }
        List<String> strings = new ArrayList<>(defectInfos.size());
        for (var defectInfo : defectInfos) {
            String fieldName = defectInfo.getPath().getFieldName();
            TranslatableIntapiDefect presentation = defectPresentationRegistry.getPresentation(defectInfo);
            Translatable defectTranslatable = presentation.getTranslatable();
            String translate = translationService.translate(defectTranslatable);
            String defectAsString = String.format("%s : %s", fieldName, translate);
            strings.add(defectAsString);
        }
        return String.join("; ", strings);
    }

}
