package ru.yandex.direct.intapi.configuration;

import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.web.context.annotation.RequestScope;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

import ru.yandex.direct.autobudget.restart.AutobudgetRestartConfiguration;
import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.common.configuration.CommonConfiguration;
import ru.yandex.direct.common.configuration.UacYdbConfiguration;
import ru.yandex.direct.communication.config.CommunicationConfiguration;
import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.core.configuration.CoreConfiguration;
import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.model.Rule;
import ru.yandex.direct.core.entity.uac.grut.GrutContext;
import ru.yandex.direct.core.entity.uac.grut.RequestScopeGrutContext;
import ru.yandex.direct.grid.core.configuration.GridCoreConfiguration;
import ru.yandex.direct.i18n.Language;
import ru.yandex.direct.intapi.BalanceClientExceptionHandlers;
import ru.yandex.direct.intapi.IntApiExceptionHandlers;
import ru.yandex.direct.intapi.entity.user.model.UserWarningsMailNotificationType;
import ru.yandex.direct.intapi.entity.user.service.UserWarningsMailTemplateResolver;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.validation.presentation.DefectPresentationRegistry;
import ru.yandex.direct.validation.result.DefaultPathNodeConverterProvider;
import ru.yandex.direct.validation.result.PathNodeConverterProvider;
import ru.yandex.direct.web.core.configuration.WebCoreConfiguration;
import ru.yandex.direct.ytcomponents.spring.YtComponentsConfiguration;
import ru.yandex.direct.ytcore.spring.YtCoreConfiguration;
import ru.yandex.grut.client.GrutClient;

import static ru.yandex.direct.intapi.entity.adgroup.presentation.AdGroupDefectPresentations.adGroupDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.adgroupadditionaltargeting.presentation.AdGroupAdditionalTargetingDefectPresentations.adGroupAdditionalTargetingDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.agency.presentation.AgencyDefectPresentations.agencyDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.banner.presentation.BannerDefectPresentations.bannerDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.bid.presentation.BidDefectPresentations.bidDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.bidmodifiers.presentation.BidModifierDefectPresentations.bidModifierDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.callout.presentation.CalloutDefectPresentations.calloutPresentationRegistry;
import static ru.yandex.direct.intapi.entity.campaign.presentation.CampaignDefectPresentations.campMetrikaCountersDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.campaign.presentation.CampaignDefectPresentations.campaignDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.campaign.presentation.CampaignDefectPresentations.strategyDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.client.presentation.ClientDefectPresentations.clientDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.creative.presentation.CreativeDefectPresentations.creativeDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.deal.presentation.DealDefectPresentations.dealDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.feature.presentation.FeatureDefectPresentations.featureDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.freelancer.presentation.FreelancerDefectPresentations.avatarsDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.freelancer.presentation.FreelancerDefectPresentations.freelancerDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.grants.presentation.GrantsDefectPresentations.grantsDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.image.presentation.ImageDefectPresentations.imageDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.internalads.presentation.InternalAdsDefectPresentation.internalAdsDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.inventori.presentation.InventoriDefectPresentations.inventoriDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.keywords.presentation.KeywordsDefectPresentations.advqPhraseDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.keywords.presentation.KeywordsDefectPresentations.keywordDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.keywords.presentation.KeywordsDefectPresentations.minusPhraseDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.keywords.presentation.KeywordsDefectPresentations.phraseDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.mobilecontent.presentation.MobileAppDefectPresentations.mobileAppDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.moderation.service.modedit.ModerationEditValidationService.modEditDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.offerretargeting.presentation.OfferRetargetingDefectPresentations.offerRetargetingDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.performance.presentation.PerformanceBannerDefectPresentations.performanceBannerDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.pricepackage.presentation.PricePackageDefectPresentations.pricePackagesDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.region.presentation.RegionDefectPresentations.regionDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.relevancematch.presentation.RelevanceMatchDefectPresentations.relevanceMatchDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.retargeting.presentation.RetargetingDefectPresentations.retargetingDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.retargeting.presentation.RetargetingPathConverters.RETARGETING_CONDITION_PRESENTATION;
import static ru.yandex.direct.intapi.entity.retargeting.presentation.RetargetingPathConverters.RETARGETING_CONDITION_RULE_PRESENTATION;
import static ru.yandex.direct.intapi.entity.retargeting.presentation.RetargetingPathConverters.RETARGETING_GOAL_PRESENTATION;
import static ru.yandex.direct.intapi.entity.showconditions.presentation.ShowConditionsDefectPresentations.showConditionsDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.sitelink.presentation.SitelinkDefectPresentations.sitelinkDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.turbolandings.presentation.TurbolandingDefectPresentations.turbolandingDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.user.presentation.UserDefectPresentations.userDefectPresentationRegistry;
import static ru.yandex.direct.intapi.entity.vcards.presentations.VcardDefectPresentations.vcardDefectPresentationRegistry;
import static ru.yandex.direct.intapi.feed.FeedDefectPresentations.feedDefectPresentationRegistry;
import static ru.yandex.direct.intapi.validation.CommonDefectPresentations.commonDefectPresentationRegistry;
import static ru.yandex.direct.intapi.validation.GridDefectPresentations.gridDefectPresentationRegistry;
import static ru.yandex.direct.validation.presentation.DefectPresentationRegistryFactory.strictRegistry;

@Import({
        CommonConfiguration.class,
        CoreConfiguration.class,
        WebCoreConfiguration.class,
        GridCoreConfiguration.class,
        YtComponentsConfiguration.class,
        YtCoreConfiguration.class,
        AutobudgetRestartConfiguration.class,
        UacYdbConfiguration.class,
        CommunicationConfiguration.class,
})
@ComponentScan(
        basePackages = {
                "ru.yandex.direct.intapi.entity",
                "ru.yandex.direct.intapi.validation"
        }
)
public class IntapiConfiguration {

    @Bean
    public IntApiExceptionHandlers intApiExceptionHandlers(TranslationService translationService) {
        return new IntApiExceptionHandlers(translationService);
    }

    @Bean
    public BalanceClientExceptionHandlers balanceClientExceptionHandlers() {
        return new BalanceClientExceptionHandlers();
    }

    @Bean
    public DefectPresentationRegistry<TranslatableIntapiDefect> defectPresentationRegistry() {
        DefaultDefectPresentationRegistry<TranslatableIntapiDefect> generalRegistry =
                DefaultDefectPresentationRegistry.builder()
                        .register(commonDefectPresentationRegistry())
                        .register(gridDefectPresentationRegistry())

                        .register(keywordDefectPresentationRegistry())
                        .register(phraseDefectPresentationRegistry())
                        .register(advqPhraseDefectPresentationRegistry())
                        .register(minusPhraseDefectPresentationRegistry())

                        .register(campaignDefectPresentationRegistry())
                        .register(campMetrikaCountersDefectPresentationRegistry())
                        .register(strategyDefectPresentationRegistry())

                        .register(clientDefectPresentationRegistry())
                        .register(freelancerDefectPresentationRegistry())
                        .register(avatarsDefectPresentationRegistry())
                        .register(imageDefectPresentationRegistry())

                        .register(adGroupDefectPresentationRegistry())
                        .register(feedDefectPresentationRegistry())
                        .register(adGroupAdditionalTargetingDefectPresentationRegistry())
                        .register(agencyDefectPresentationRegistry())
                        .register(bannerDefectPresentationRegistry())
                        .register(bidDefectPresentationRegistry())
                        .register(bidModifierDefectPresentationRegistry())
                        .register(calloutPresentationRegistry())
                        .register(creativeDefectPresentationRegistry())
                        .register(dealDefectPresentationRegistry())
                        .register(featureDefectPresentationRegistry())
                        .register(grantsDefectPresentationRegistry())
                        .register(mobileAppDefectPresentationRegistry())
                        .register(regionDefectPresentationRegistry())
                        .register(relevanceMatchDefectPresentationRegistry())
                        .register(offerRetargetingDefectPresentationRegistry())
                        .register(retargetingDefectPresentationRegistry())
                        .register(showConditionsDefectPresentationRegistry())
                        .register(sitelinkDefectPresentationRegistry())
                        .register(vcardDefectPresentationRegistry())
                        .register(inventoriDefectPresentationRegistry())
                        .register(internalAdsDefectPresentationRegistry())
                        .register(performanceBannerDefectPresentationRegistry())
                        .register(pricePackagesDefectPresentationRegistry())
                        .register(userDefectPresentationRegistry())
                        .register(turbolandingDefectPresentationRegistry())
                        .register(modEditDefectPresentationRegistry())
                        .build();

        // кидаем исключение, если презентация не найдена
        return strictRegistry(generalRegistry);
    }

    @Bean
    public PathNodeConverterProvider defaultIntapiPathNodeConverterProvider() {
        return DefaultPathNodeConverterProvider.builder()
                .register(RetargetingCondition.class, RETARGETING_CONDITION_PRESENTATION)
                .register(Rule.class, RETARGETING_CONDITION_RULE_PRESENTATION)
                .register(Goal.class, RETARGETING_GOAL_PRESENTATION)
                .build();
    }

    @Bean
    UserWarningsMailTemplateResolver walletsWarningsMailTemplateResolver(DirectConfig directConfig) {
        DirectConfig walletsWarningsMails = directConfig.getBranch("user_warnings_mails");
        Map<Language, Map<UserWarningsMailNotificationType, String>> templatesMap = new EnumMap<>(Language.class);
        for (Language lang : Language.values()) {
            DirectConfig langsBranch = walletsWarningsMails.getBranch(lang.getLangString());
            Map<UserWarningsMailNotificationType, String> langsMappings =
                    new EnumMap<>(UserWarningsMailNotificationType.class);
            for (UserWarningsMailNotificationType notification : UserWarningsMailNotificationType.values()) {
                Optional<String> templateName = langsBranch.findString(notification.name());
                templateName.filter(str -> !str.isEmpty()).ifPresent(s -> langsMappings.put(notification, s));
            }
            templatesMap.put(lang, langsMappings);
        }
        return new UserWarningsMailTemplateResolver(templatesMap);
    }

    @Bean
    @RequestScope
    public GrutContext grutContext(GrutClient grutClient) {
        return new RequestScopeGrutContext(grutClient);
    }

    @Bean
    public CommonsMultipartResolver multipartResolver(DirectConfig conf) {
        DirectConfig multipartConfig = conf.getBranch("multipart_config");
        CommonsMultipartResolver resolver = new CommonsMultipartResolver();
        resolver.setDefaultEncoding(multipartConfig.getString("default_encoding"));
        resolver.setMaxUploadSize(multipartConfig.getLong("max_upload_size"));
        resolver.setMaxUploadSizePerFile(multipartConfig.getLong("max_upload_size_per_file"));
        return resolver;
    }
}
