package ru.yandex.direct.intapi.entity;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.intapi.validation.model.IntapiSuccessResponse;
import ru.yandex.direct.intapi.validation.model.IntapiValidationResult;

public abstract class MassResponse<T> extends IntapiSuccessResponse {
    private T result;
    private IntapiValidationResult intapiValidationResult;

    @JsonGetter("result")
    public T getResult() {
        return result;
    }

    @JsonProperty("validation_result")
    public IntapiValidationResult validationResult() {
        return intapiValidationResult;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public void setIntapiValidationResult(IntapiValidationResult webValidationResult) {
        this.intapiValidationResult = webValidationResult;
    }

    public <R extends MassResponse<T>> R withResult(T result) {
        setResult(result);
        //noinspection unchecked
        return (R) this;
    }

    public <R extends MassResponse<T>> R withValidation(IntapiValidationResult validationResult) {
        setIntapiValidationResult(validationResult);
        //noinspection unchecked
        return (R) this;
    }
}
