package ru.yandex.direct.intapi.entity.adgroup.presentation;

import ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds;
import ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectTranslations;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;

import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.AppStoreDomain.APP_STORE_IS_NOT_SUPPORTED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.ADVERTISED_APP_LINK_IS_NOT_SET;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.AD_GROUP_DOES_NOT_CONTAIN_THIS_BANNER;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.AD_GROUP_DOES_NOT_CONTAIN_THIS_KEYWORD;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.AD_GROUP_DOES_NOT_CONTAIN_THIS_RELEVANCE_MATCH;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.AD_GROUP_NAME_CANT_BE_EMPTY;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.AD_GROUP_NAME_IS_NOT_SET;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.AD_GROUP_STATUS_ARCHIVED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.AD_GROUP_STATUS_STOPPED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.AD_GROUP_TYPE_NOT_SUPPORTED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.ARCHIVED_AD_GROUP_MODIFICATION;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.BID_MODIFIERS_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.BS_TAG_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.CONTENT_PROMOTION_ADGROUP_TYPE_CHANGED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.CONTENT_PROMOTION_DISTINCT_TYPE_FROM_EXISTING;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.CONTENT_PROMOTION_SEVERAL_TYPES_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.DEVICE_TARGETING_IS_NOT_SET;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.DYNAMIC_TEXT_DOMAIN_IS_NOT_SET;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.EITHER_KEYWORDS_OR_RETARGETINGS_ALLOWED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.EMPTY_CONTENT_CATEGORIES_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.FINISH_TIME_SHOULD_BE_GREATER_THAN_START_TIME;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.INCONSISTENT_AD_GROUP_TYPE;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.INCONSISTENT_AD_GROUP_TYPE_TO_CAMPAIGN_TYPE;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.INCONSISTENT_DYNAMIC_AD_GROUP_TYPE;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.INVALID_APP_LINK_FORMAT;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.INVALID_APP_STORE_URL;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.INVALID_DYNAMIC_TEXT_DOMAIN;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.INVALID_MIN_OS_VERSION;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.KEYWORDS_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.MINUS_KEYWORDS_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.MIN_OS_VERSION_IS_NOT_SET;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.MUST_BE_MUTUALLY_EXCLUSIVE;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.MUST_NOT_CONTAIN_DUPLICATED_OBJECTS;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.NETWORK_TARGETING_IS_NOT_SET;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.NOT_ALLOWED_VALUE;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.NOT_FOUND;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.ONLY_ONE_DEFAULT_AD_GROUP_ALLOWED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.PRICE_SALES_AD_GROUP_NOT_ALLOWED_MOBILE_PLATFORMS_COMBINATION;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.PRICE_SALES_AD_GROUP_TYPE_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.PRICE_SALES_AD_GROUP_USE_NOT_ALLOWED_BID_MODIFIERS;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.PRICE_SALES_DISALLOWED_ADGROUP_TYPE;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.PRICE_SALES_DISALLOWED_AUDIENCE_SEGMENTS;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.PRICE_SALES_DISALLOWED_METRIKA_SEGMENTS;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.PRICE_SALES_INVALID_PRIORITY;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.RESTRICTED_REGIONS;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.STORE_URL_MUST_BE_SAME_AS_URL_IN_MOBILE_CONTENT_CAMPAIGN;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.STORE_URL_MUST_BE_SAME_FOR_ALL_GROUPS_IN_MOBILE_CONTENT_CAMPAIGN;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.UNABLE_TO_DELETE;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.UNSUPPORTED_GROUP_TYPE;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Geo.BAD_GEO;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.ModelId.FEED_NOT_EXIST;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Number.MAX_ADGROUPS_IN_CAMPAIGN;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Number.TOO_MANY_BANNERS_IN_AD_GROUP;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.String.AD_GROUP_NAME_TOO_LONG;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.intapiDefect;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.paramIntapiDefect;

public class AdGroupDefectPresentations {

    private AdGroupDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> adGroupDefectPresentationRegistry() {
        AdGroupDefectTranslations translations = AdGroupDefectTranslations.INSTANCE;
        CommonDefectTranslations commonTranslations = CommonDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(ARCHIVED_AD_GROUP_MODIFICATION,
                        intapiDefect(translations.cantEditArchivedAdGroup()))
                .register(BAD_GEO,
                        defaultIntapiDefect())
                .register(UNSUPPORTED_GROUP_TYPE,
                        defaultIntapiDefect())
                .register(MUST_BE_MUTUALLY_EXCLUSIVE,
                        defaultIntapiDefect())
                .register(AD_GROUP_DOES_NOT_CONTAIN_THIS_KEYWORD,
                        defaultIntapiDefect())
                .register(AD_GROUP_DOES_NOT_CONTAIN_THIS_RELEVANCE_MATCH,
                        defaultIntapiDefect())
                .register(AD_GROUP_DOES_NOT_CONTAIN_THIS_BANNER,
                        defaultIntapiDefect())
                .register(TOO_MANY_BANNERS_IN_AD_GROUP,
                        defaultIntapiDefect())
                .register(MAX_ADGROUPS_IN_CAMPAIGN,
                        paramIntapiDefect(di -> translations.campaignAdGroupsLimitReached(
                                new Identity(di.getDefect().params().getMax().longValue()))))
                .register(INCONSISTENT_AD_GROUP_TYPE_TO_CAMPAIGN_TYPE,
                        intapiDefect(translations.inconsistentAdGroupTypeToCampaignType()))
                .register(AD_GROUP_NAME_IS_NOT_SET,
                        defaultIntapiDefect())
                .register(AD_GROUP_NAME_CANT_BE_EMPTY,
                        defaultIntapiDefect())
                .register(AD_GROUP_NAME_TOO_LONG,
                        defaultIntapiDefect())
                .register(ADVERTISED_APP_LINK_IS_NOT_SET,
                        defaultIntapiDefect())
                .register(FEED_NOT_EXIST,
                        defaultIntapiDefect())
                .register(INVALID_APP_LINK_FORMAT,
                        defaultIntapiDefect())
                .register(APP_STORE_IS_NOT_SUPPORTED,
                        defaultIntapiDefect())
                .register(INVALID_APP_STORE_URL,
                        defaultIntapiDefect())
                .register(MIN_OS_VERSION_IS_NOT_SET,
                        defaultIntapiDefect())
                .register(INVALID_MIN_OS_VERSION,
                        defaultIntapiDefect())
                .register(DEVICE_TARGETING_IS_NOT_SET,
                        defaultIntapiDefect())
                .register(NETWORK_TARGETING_IS_NOT_SET,
                        defaultIntapiDefect())
                .register(DYNAMIC_TEXT_DOMAIN_IS_NOT_SET,
                        defaultIntapiDefect())
                .register(INVALID_DYNAMIC_TEXT_DOMAIN,
                        defaultIntapiDefect())
                .register(NOT_FOUND,
                        defaultIntapiDefect())
                .register(UNABLE_TO_DELETE,
                        defaultIntapiDefect())
                .register(MUST_NOT_CONTAIN_DUPLICATED_OBJECTS,
                        defaultIntapiDefect())
                .register(AD_GROUP_TYPE_NOT_SUPPORTED,
                        intapiDefect(commonTranslations.adGroupTypeNotSupportedDetailed()))
                .register(INCONSISTENT_AD_GROUP_TYPE,
                        defaultIntapiDefect())
                .register(INCONSISTENT_DYNAMIC_AD_GROUP_TYPE,
                        defaultIntapiDefect())
                .register(EITHER_KEYWORDS_OR_RETARGETINGS_ALLOWED,
                        defaultIntapiDefect())
                .register(EMPTY_CONTENT_CATEGORIES_NOT_ALLOWED,
                        defaultIntapiDefect())
                .register(CONTENT_PROMOTION_SEVERAL_TYPES_NOT_ALLOWED,
                        defaultIntapiDefect())
                .register(CONTENT_PROMOTION_DISTINCT_TYPE_FROM_EXISTING,
                        defaultIntapiDefect())
                .register(CONTENT_PROMOTION_ADGROUP_TYPE_CHANGED,
                        defaultIntapiDefect())
                .register(KEYWORDS_NOT_ALLOWED,
                        defaultIntapiDefect())
                .register(BID_MODIFIERS_NOT_ALLOWED,
                        defaultIntapiDefect())
                .register(MINUS_KEYWORDS_NOT_ALLOWED,
                        defaultIntapiDefect())
                .register(RESTRICTED_REGIONS,
                        defaultIntapiDefect())
                .register(STORE_URL_MUST_BE_SAME_FOR_ALL_GROUPS_IN_MOBILE_CONTENT_CAMPAIGN,
                        defaultIntapiDefect())
                .register(STORE_URL_MUST_BE_SAME_AS_URL_IN_MOBILE_CONTENT_CAMPAIGN,
                        defaultIntapiDefect())
                .register(NOT_ALLOWED_VALUE,
                        defaultIntapiDefect())
                .register(BS_TAG_NOT_ALLOWED,
                        defaultIntapiDefect())
                .register(FINISH_TIME_SHOULD_BE_GREATER_THAN_START_TIME,
                        defaultIntapiDefect())
                .register(ONLY_ONE_DEFAULT_AD_GROUP_ALLOWED,
                        defaultIntapiDefect())
                .register(PRICE_SALES_DISALLOWED_ADGROUP_TYPE,
                        defaultIntapiDefect())
                .register(PRICE_SALES_DISALLOWED_METRIKA_SEGMENTS,
                        defaultIntapiDefect())
                .register(PRICE_SALES_DISALLOWED_AUDIENCE_SEGMENTS,
                        defaultIntapiDefect())
                .register(PRICE_SALES_AD_GROUP_TYPE_NOT_ALLOWED,
                        defaultIntapiDefect())
                .register(PRICE_SALES_INVALID_PRIORITY,
                        defaultIntapiDefect())
                .register(PRICE_SALES_AD_GROUP_USE_NOT_ALLOWED_BID_MODIFIERS,
                        defaultIntapiDefect())
                .register(PRICE_SALES_AD_GROUP_NOT_ALLOWED_MOBILE_PLATFORMS_COMBINATION,
                        defaultIntapiDefect())
                .register(AD_GROUP_STATUS_ARCHIVED,
                        defaultIntapiDefect())
                .register(AD_GROUP_STATUS_STOPPED,
                        defaultIntapiDefect())
                .register(AdGroupDefectIds.PriceSalesTargetingAmount.TOO_FEW_TARGETINGS,
                        defaultIntapiDefect())
                .register(AdGroupDefectIds.PriceSalesTargetingAmount.TOO_MANY_TARGETINGS,
                        defaultIntapiDefect())
                .register(AdGroupDefectIds.Banners.REQUIRED_AGE_VARIABLE,
                        defaultIntapiDefect())


                .build();
    }
}
