package ru.yandex.direct.intapi.entity.adgroupbstags.controller;

import javax.ws.rs.POST;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.direct.intapi.entity.adgroupbstags.model.AdGroupBsTagsRequest;
import ru.yandex.direct.intapi.entity.adgroupbstags.model.CampaignAdGroupsBsTagsRequest;
import ru.yandex.direct.intapi.entity.adgroupbstags.service.AdGroupBsTagsIntapiService;
import ru.yandex.direct.intapi.validation.model.IntapiValidationResponse;
import ru.yandex.direct.tvm.AllowServices;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.direct.web.core.model.WebResponse;

import static ru.yandex.direct.tvm.TvmService.DIRECT_AUTOTESTS;
import static ru.yandex.direct.tvm.TvmService.DIRECT_DEVELOPER;
import static ru.yandex.direct.tvm.TvmService.EATS_ADVERTS;
import static ru.yandex.direct.tvm.TvmService.EDA_RESTAPP_MARKETING_PROD;
import static ru.yandex.direct.tvm.TvmService.EDA_RESTAPP_MARKETING_TEST;
import static ru.yandex.direct.tvm.TvmService.GEO_PRODUCT_PROD;
import static ru.yandex.direct.tvm.TvmService.GEO_PRODUCT_TEST;
import static ru.yandex.direct.tvm.TvmService.TURBO_ECOM_PROD;
import static ru.yandex.direct.tvm.TvmService.TURBO_ECOM_TEST;
import static ru.yandex.direct.tvm.TvmService.YDO_PROD;
import static ru.yandex.direct.tvm.TvmService.YDO_TEST;

@RestController
@RequestMapping(
        name = "adgroup_bs_tags",
        path = "/adgroup_bs_tags",
        produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(value = "API для работы с тегами БК на группах")
public class AdGroupBsTagsController {
    private static final Logger logger = LoggerFactory.getLogger(AdGroupBsTagsController.class);

    private final AdGroupBsTagsIntapiService adGroupBsTagsService;

    @Autowired
    public AdGroupBsTagsController(AdGroupBsTagsIntapiService adGroupBsTagsService) {
        this.adGroupBsTagsService = adGroupBsTagsService;
    }

    @POST
    @ApiOperation(
            value = "Проставляет группам кампаний в директе теги БК, соответствующие услугам",
            nickname = "set_ydo_bs_tags",
            httpMethod = "POST"
    )
    @ApiResponses({
            @ApiResponse(code = 200, message = "Успешный ответ", response = IntapiValidationResponse.class),
            @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
            @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class)})
    @RequestMapping(path = "set_ydo_bs_tags", method = RequestMethod.POST)
    @AllowServices(production = {YDO_PROD},
            testing = {DIRECT_DEVELOPER, DIRECT_AUTOTESTS, YDO_PROD, YDO_TEST})
    public WebResponse setYdoBsTags(
            @ApiParam(value = "запрос на проставление тегов", required = true)
            @RequestBody CampaignAdGroupsBsTagsRequest request) {
        try {
            return adGroupBsTagsService.setYdoAdGroupBsTags(request.getUid(), request.getCids());
        } catch (Exception e) {
            logger.error("Exception while setting tags", e);
            return new WebErrorResponse(1000, e.getMessage());
        }
    }

    @POST
    @ApiOperation(
            value = "Проставляет группам или получает у групп в Директе БК-теги, для нужд Я.Услуг",
            nickname = "ydo_bs_tags",
            httpMethod = "POST"
    )
    @ApiResponses({
            @ApiResponse(code = 200, message = "Успешный ответ", response = IntapiValidationResponse.class),
            @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
            @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class)})
    @RequestMapping(path = "ydo_bs_tags", method = RequestMethod.POST)
    @AllowServices(production = {YDO_PROD, GEO_PRODUCT_PROD},
            testing = {DIRECT_DEVELOPER, DIRECT_AUTOTESTS, YDO_PROD, YDO_TEST, GEO_PRODUCT_PROD, GEO_PRODUCT_TEST})
    public WebResponse ydoAdGroupBsTags(
            @ApiParam(value = "запрос на проставление или получение тегов", required = true)
            @RequestBody AdGroupBsTagsRequest request) {
        try {
            if (request.getBsTags() != null) {
                return adGroupBsTagsService.setYdoAdGroupBsTags(request.getAdGroupIds(), request.getBsTags());
            } else {
                return adGroupBsTagsService.getYdoAdGroupBsTags(request.getAdGroupIds());
            }
        } catch (Exception e) {
            logger.error("Exception while setting tags", e);
            return new WebErrorResponse(1000, e.getMessage());
        }
    }

    @POST
    @ApiOperation(
            value = "Проставляет группам или получает у групп в Директе БК-теги, для нужд Я.Еды",
            nickname = "eda_bs_tags",
            httpMethod = "POST"
    )
    @ApiResponses({
            @ApiResponse(code = 200, message = "Успешный ответ", response = IntapiValidationResponse.class),
            @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
            @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class)})
    @RequestMapping(path = "eda_bs_tags", method = RequestMethod.POST)
    @AllowServices(production = {EDA_RESTAPP_MARKETING_PROD, EATS_ADVERTS},
            testing = {DIRECT_DEVELOPER, DIRECT_AUTOTESTS,
                    EDA_RESTAPP_MARKETING_PROD, EDA_RESTAPP_MARKETING_TEST, EATS_ADVERTS})
    public WebResponse edaAdGroupBsTags(
            @ApiParam(value = "запрос на проставление или получение тегов", required = true)
            @RequestBody AdGroupBsTagsRequest request) {
        try {
            if (request.getBsTags() != null) {
                return adGroupBsTagsService.setEdaAdGroupBsTags(request.getAdGroupIds(), request.getBsTags());
            } else {
                return adGroupBsTagsService.getEdaAdGroupBsTags(request.getAdGroupIds());
            }
        } catch (Exception e) {
            logger.error("Exception while setting tags", e);
            return new WebErrorResponse(1000, e.getMessage());
        }
    }

    @POST
    @ApiOperation(
            value = "Проставляет группам кампаний в директе теги БК, соответствующие картам",
            nickname = "set_maps_test_bs_tags",
            httpMethod = "POST"
    )
    @ApiResponses({
            @ApiResponse(code = 200, message = "Успешный ответ", response = IntapiValidationResponse.class),
            @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
            @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class)})
    @RequestMapping(path = "set_maps_test_bs_tags", method = RequestMethod.POST)
    @AllowServices(production = {GEO_PRODUCT_PROD},
            testing = {DIRECT_DEVELOPER, DIRECT_AUTOTESTS, GEO_PRODUCT_PROD, GEO_PRODUCT_TEST})
    public WebResponse setMapsTestBsTags(
            @ApiParam(value = "запрос на проставление тегов", required = true)
            @RequestBody CampaignAdGroupsBsTagsRequest request) {
        try {
            return adGroupBsTagsService.setMapsTestAdGroupBsTags(request.getUid(), request.getCids());
        } catch (Exception e) {
            logger.error("Exception while setting tags", e);
            return new WebErrorResponse(1000, e.getMessage());
        }
    }

    @POST
    @ApiOperation(
            value = "Проставляет группам кампаний в директе теги БК для turbo ecom DIRECT-111215",
            nickname = "set_turbo_ecom_bs_tags",
            httpMethod = "POST"
    )
    @ApiResponses({
            @ApiResponse(code = 200, message = "Успешный ответ", response = IntapiValidationResponse.class),
            @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
            @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class)})
    @RequestMapping(path = "set_turbo_ecom_bs_tags", method = RequestMethod.POST)
    @AllowServices(production = {TURBO_ECOM_PROD},
            testing = {TURBO_ECOM_TEST, DIRECT_DEVELOPER, DIRECT_AUTOTESTS})
    public WebResponse setTurboEcomBsTags(
            @ApiParam(value = "запрос на добавление turbo ecom", required = true)
            @RequestBody CampaignAdGroupsBsTagsRequest request) {
        try {
            return adGroupBsTagsService.setTurboEcomAdGroupBsTags(request.getUid(), request.getCids());
        } catch (Exception e) {
            logger.error("Exception while setting tags", e);
            return new WebErrorResponse(1000, e.getMessage());
        }
    }

    @POST
    @ApiOperation(
            value = "Проставляет группам кампаний в директе теги БК для показа " +
                    "Яндекс.Бизнеса на пейджах Едадила DIRECT-148429",
            nickname = "set_edadeal_geoprod_bs_tags",
            httpMethod = "POST"
    )
    @ApiResponses({
            @ApiResponse(code = 200, message = "Успешный ответ", response = IntapiValidationResponse.class),
            @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
            @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class)})
    @RequestMapping(path = "set_edadeal_geoprod_bs_tags", method = RequestMethod.POST)
    @AllowServices(production = {GEO_PRODUCT_PROD},
            testing = {GEO_PRODUCT_TEST, DIRECT_DEVELOPER, DIRECT_AUTOTESTS})
    public WebResponse setEdadealGeoprodTags(
            @ApiParam(value = "запрос на добавление edadeal-geoprod", required = true)
            @RequestBody CampaignAdGroupsBsTagsRequest request) {
        try {
            return adGroupBsTagsService.setEdadealGeoprodAdGroupBsTags(request.getUid(), request.getCids());
        } catch (Exception e) {
            logger.error("Exception while setting tags", e);
            return new WebErrorResponse(1000, e.getMessage());
        }
    }

    @POST
    @ApiOperation(
            value = "Проставляет группам кампаний в директе теги БК для mini app " +
                    "https://st.yandex-team.ru/TURBO-2830#5eb47d47ab2c182f5ba126f7",
            nickname = "set_miniapp_bs_tags",
            httpMethod = "POST"
    )
    @ApiResponses({
            @ApiResponse(code = 200, message = "Успешный ответ", response = IntapiValidationResponse.class),
            @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
            @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class)})
    @RequestMapping(path = "set_miniapp_bs_tags", method = RequestMethod.POST)
    @AllowServices(production = {TURBO_ECOM_PROD},
            testing = {TURBO_ECOM_TEST, DIRECT_DEVELOPER, DIRECT_AUTOTESTS})
    public WebResponse setMiniAppBsTags(
            @ApiParam(value = "запрос на добавление miniapp тега", required = true)
            @RequestBody CampaignAdGroupsBsTagsRequest request) {
        try {
            return adGroupBsTagsService.setMiniAppAdGroupBsTags(request.getUid(), request.getCids());
        } catch (Exception e) {
            logger.error("Exception while setting tags", e);
            return new WebErrorResponse(1000, e.getMessage());
        }
    }

    @POST
    @ApiOperation(
            value = "Проставляет группам кампаний в директе теги БК для turbo ecom и miniapp " +
                    "https://st.yandex-team.ru/TURBO-2830#5eb47d47ab2c182f5ba126f7",
            nickname = "set_turbo_ecom_and_miniapp_bs_tags",
            httpMethod = "POST"
    )
    @ApiResponses({
            @ApiResponse(code = 200, message = "Успешный ответ", response = IntapiValidationResponse.class),
            @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
            @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class)})
    @RequestMapping(path = "set_turbo_ecom_and_miniapp_bs_tags", method = RequestMethod.POST)
    @AllowServices(production = {TURBO_ECOM_PROD},
            testing = {TURBO_ECOM_TEST, DIRECT_DEVELOPER, DIRECT_AUTOTESTS})
    public WebResponse setTurboAndMiniappBsTags(
            @ApiParam(value = "запрос на добавление turbo_and_miniapp тега", required = true)
            @RequestBody CampaignAdGroupsBsTagsRequest request) {
        try {
            return adGroupBsTagsService.setTurboAndMiniAppEcomAdGroupBsTags(request.getUid(), request.getCids());
        } catch (Exception e) {
            logger.error("Exception while setting tags", e);
            return new WebErrorResponse(1000, e.getMessage());
        }
    }
}
