package ru.yandex.direct.intapi.entity.adgroupbstags.model;

import java.util.List;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class AdGroupBsTagsRequest {

    @Nonnull
    @JsonProperty("ad_group_ids")
    private final List<Long> adGroupIds;

    @JsonProperty("bs_tags")
    private final List<String> bsTags;

    @JsonCreator
    public AdGroupBsTagsRequest(
            @Nonnull @JsonProperty("ad_group_ids") List<Long> adGroupIds,
            @JsonProperty("bs_tags") List<String> bsTags) {
        this.adGroupIds = adGroupIds;
        this.bsTags = bsTags;
    }

    @Nonnull
    public List<Long> getAdGroupIds() {
        return adGroupIds;
    }

    public List<String> getBsTags() {
        return bsTags;
    }
}
