package ru.yandex.direct.intapi.entity.adgroupbstags.model;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import one.util.streamex.EntryStream;

import ru.yandex.direct.intapi.validation.model.IntapiValidationResponse;
import ru.yandex.direct.intapi.validation.model.IntapiValidationResult;

import static ru.yandex.direct.utils.FunctionalUtils.listToMap;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class AdGroupBsTagsResponse extends IntapiValidationResponse {

    @JsonProperty("ad_group_bs_tags")
    private final List<AdGroupBsTagsItem> adGroupBsTags;

    public AdGroupBsTagsResponse(IntapiValidationResult intapiValidationResult) {
        super(intapiValidationResult);
        this.adGroupBsTags = null;
    }

    public AdGroupBsTagsResponse(IntapiValidationResult intapiValidationResult,
                                 @Nonnull Map<Long, List<String>> adGroupBsTags) {
        super(intapiValidationResult);
        this.adGroupBsTags = EntryStream.of(adGroupBsTags)
                .map(e -> new AdGroupBsTagsItem(e.getKey(), e.getValue())).toList();
    }

    public List<AdGroupBsTagsItem> getAdGroupBsTags() {
        return adGroupBsTags;
    }

    @JsonIgnore
    public Map<Long, List<String>> getBsTagsByAdGroupId() {
        return listToMap(adGroupBsTags, AdGroupBsTagsItem::getAdGroupId, AdGroupBsTagsItem::getBsTags);
    }

    private static class AdGroupBsTagsItem {
        @JsonProperty("ad_group_id")
        private final Long adGroupId;
        @JsonProperty("bs_tags")
        private final List<String> bsTags;

        private AdGroupBsTagsItem(Long adGroupId, List<String> bsTags) {
            this.adGroupId = adGroupId;
            this.bsTags = bsTags;
        }

        public Long getAdGroupId() {
            return adGroupId;
        }

        public List<String> getBsTags() {
            return bsTags;
        }
    }
}
