package ru.yandex.direct.intapi.entity.adgroupbstags.model;

import java.util.List;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CampaignAdGroupsBsTagsRequest {

    @JsonProperty("cids")
    @Nonnull
    private final List<Long> cids;

    @JsonProperty("uid")
    @Nonnull
    private final Long uid;


    @JsonCreator
    public CampaignAdGroupsBsTagsRequest(
            @NonNull @JsonProperty("cids") List<Long> cids,
            @NonNull @JsonProperty("uid") Long uid) {
        this.cids = cids;
        this.uid = uid;
    }

    @Nonnull
    public List<Long> getCids() {
        return cids;
    }

    @Nonnull
    public Long getUid() {
        return uid;
    }
}
