package ru.yandex.direct.intapi.entity.adqualityexport;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.web.core.entity.adqualityexport.AdQualityExportActionType;
import ru.yandex.direct.web.core.entity.adqualityexport.AdQualityExportLogEntity;
import ru.yandex.direct.web.core.entity.adqualityexport.AdQualityExportLoggerBase;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;


@Service
public class AdQualityExportLogger extends AdQualityExportLoggerBase {

    public void logAddedKeywords(Map<String, Keyword> rowHashToKeyword) {
        List<AdQualityExportLogEntity> logEntities = getAdGroupLogEntity(rowHashToKeyword);
        doLogForExport(logEntities);
    }

    private List<AdQualityExportLogEntity> getAdGroupLogEntity(Map<String, Keyword> rowHashToKeyword) {

        List<AdQualityExportLogEntity> result = mapList(rowHashToKeyword.keySet(),
                rowHash -> {
                    Keyword keyword = rowHashToKeyword.get(rowHash);
                    return new AdQualityExportLogEntity()
                            .withUserProvidedText(keyword.getPhrase())
                            .withActionType(AdQualityExportActionType.PZ_ADGROUP_ADD_KEYWORD)
                            .withPid(keyword.getAdGroupId())
                            .withReportRowHash(rowHash)
                            .withUserNormText(keyword.getNormPhrase());
                });

        return result;
    }
}
