package ru.yandex.direct.intapi.entity.auction.controller;

import java.util.List;

import javax.ws.rs.POST;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.direct.common.net.NetworkName;
import ru.yandex.direct.intapi.ErrorResponse;
import ru.yandex.direct.intapi.entity.auction.model.InterpolateRequest;
import ru.yandex.direct.intapi.entity.auction.model.PhraseAuctionItem;
import ru.yandex.direct.intapi.entity.auction.service.InterpolateAuctionItemsService;
import ru.yandex.direct.web.core.security.netacl.AllowNetworks;

/**
 * Ручки связанные с торгами
 */
@RestController
@RequestMapping("auction")
@Api(tags = "auction")
@AllowNetworks(NetworkName.DIRECT_PRODUCTION)
public class AuctionController {
    private final InterpolateAuctionItemsService interpolateAuctionItemsService;

    @Autowired
    public AuctionController(InterpolateAuctionItemsService interpolateAuctionItemsService) {
        this.interpolateAuctionItemsService = interpolateAuctionItemsService;
    }

    @POST
    @ApiOperation(
            value = "interpolate",
            httpMethod = "POST",
            nickname = "interpolate"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = ErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = List.class)
            }
    )
    @RequestMapping(path = "/interpolate",
            method = RequestMethod.POST,
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE,
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ResponseBody
    public List<PhraseAuctionItem> getInterpolatedPoints(@RequestBody InterpolateRequest interpolateRequest) {
        return interpolateAuctionItemsService.interpolate(interpolateRequest);
    }
}
