package ru.yandex.direct.intapi.entity.auction.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class AuctionItem {
    public static final String BID = "bid";
    public static final String AMNESTY_PRICE = "amnesty_price";
    public static final String TRAFFIC_VOLUME = "traffic_volume";

    @JsonProperty(BID)
    private long bid;
    @JsonProperty(AMNESTY_PRICE)
    private long amnestyPrice;
    @JsonProperty(TRAFFIC_VOLUME)
    private long trafficVolume;

    public long getBid() {
        return bid;
    }

    public AuctionItem withBid(long bid) {
        this.bid = bid;
        return this;
    }

    public long getAmnestyPrice() {
        return amnestyPrice;
    }

    public AuctionItem withAmnestyPrice(long amnestyPrice) {
        this.amnestyPrice = amnestyPrice;
        return this;
    }

    public long getTrafficVolume() {
        return trafficVolume;
    }

    public AuctionItem withTrafficVolume(long trafficVolume) {
        this.trafficVolume = trafficVolume;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        AuctionItem that = (AuctionItem) o;

        if (bid != that.bid) {
            return false;
        }
        if (amnestyPrice != that.amnestyPrice) {
            return false;
        }
        return trafficVolume == that.trafficVolume;
    }

    @Override
    public int hashCode() {
        int result = (int) (bid ^ (bid >>> 32));
        result = 31 * result + (int) (amnestyPrice ^ (amnestyPrice >>> 32));
        result = 31 * result + (int) (trafficVolume ^ (trafficVolume >>> 32));
        return result;
    }

    @Override
    public String toString() {
        return "AuctionItem{" +
                "bid=" + bid +
                ", amnestyPrice=" + amnestyPrice +
                ", trafficVolume=" + trafficVolume +
                '}';
    }
}
