package ru.yandex.direct.intapi.entity.auction.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.currency.CurrencyCode;

public class PhraseAuctionItem {
    public static final String AUCTION_ITEMS = "auction_items";
    public static final String DOMAIN = "domain";
    public static final String IS_EXACT_MATCH = "is_exact_match";
    public static final String CURRENCY_CODE = "currency_code";
    public static final String CALCULATING_TRAFFIC_VOLUMES = "calculating_traffic_volumes";

    @JsonProperty(AUCTION_ITEMS)
    private List<AuctionItem> auctionItems;

    @JsonProperty(DOMAIN)
    private String domain;

    @JsonProperty(IS_EXACT_MATCH)
    private boolean isExactMatch;

    @JsonProperty(CURRENCY_CODE)
    private CurrencyCode currencyCode;

    @JsonProperty(CALCULATING_TRAFFIC_VOLUMES)
    private List<Long> calculatingTrafficVolumes;

    public List<AuctionItem> getAuctionItems() {
        return auctionItems;
    }

    public PhraseAuctionItem withAuctionItems(List<AuctionItem> auctionItems) {
        this.auctionItems = auctionItems;
        return this;
    }

    public String getDomain() {
        return domain;
    }

    public PhraseAuctionItem withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public boolean getIsExactMatch() {
        return isExactMatch;
    }

    public PhraseAuctionItem withExactMatch(boolean exactMatch) {
        isExactMatch = exactMatch;
        return this;
    }

    public CurrencyCode getCurrencyCode() {
        return currencyCode;
    }

    public PhraseAuctionItem withCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    public List<Long> getCalculatingTrafficVolumes() {
        return calculatingTrafficVolumes;
    }

    public PhraseAuctionItem withCalculatingTrafficVolumes(List<Long> calculatingTrafficVolumes) {
        this.calculatingTrafficVolumes = calculatingTrafficVolumes;
        return this;
    }
}
