package ru.yandex.direct.intapi.entity.balanceclient.container;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import ru.yandex.direct.intapi.entity.balanceclient.model.GetHostingsResult;

/**
 * Класс-обертка для представления ответа Балансу на запрос GetHostings.
 */
@ParametersAreNonnullByDefault
public class BalanceClientGetHostingsResponse extends ResponseEntity<GetHostingsResult> {
    public BalanceClientGetHostingsResponse(GetHostingsResult result, HttpStatus status) {
        super(result, defaultHeaders(), status);
    }

    public static BalanceClientGetHostingsResponse success(Set<String> hostings, Set<String> publicSecondLevelDomains) {
        return new BalanceClientGetHostingsResponse(new GetHostingsResult(hostings, publicSecondLevelDomains),
                HttpStatus.OK);
    }

    private static HttpHeaders defaultHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        return headers;
    }
}
