package ru.yandex.direct.intapi.entity.balanceclient.container;

import java.math.BigDecimal;
import java.time.LocalDate;

import ru.yandex.direct.core.entity.campaign.model.AggregatingSumStatus;
import ru.yandex.direct.core.entity.campaign.model.CampaignSource;
import ru.yandex.direct.core.entity.campaign.model.CampaignStatusModerate;
import ru.yandex.direct.core.entity.campaign.model.CampaignStatusPostmoderate;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.currency.CurrencyCode;

public class CampaignDataForNotifyOrder {
    private Long campaignId;
    private BigDecimal sum;
    private BigDecimal sumBalance;
    private BigDecimal sumSpent;
    private Long balanceTid;
    private Boolean statusShow;
    private Long sumUnits;
    private Long sumSpentUnits;
    private BigDecimal cashback;
    private BigDecimal totalCashback;
    private Boolean statusEmpty;
    private Boolean archived;
    private Boolean startTimeInFuture;
    private Long productId;
    private Long cmsBalanceTid;
    private BigDecimal cmsSum;
    private BigDecimal cmsChipsCost;
    private BigDecimal cmsChipsSpent;
    private CurrencyCode currency;
    private Boolean firstAfterCopyConvert;
    private Boolean currencyConverted;
    private String email;
    private String fio;
    private String login;
    private String phone;
    private Long startTimeTs;
    private LocalDate finishDate;
    private String lang;
    private Boolean paidByCertificate;
    private Long totalBalanceTid;
    private BigDecimal totalSum;
    private CurrencyCode clientWorkCurrency;

    private Long orderId;
    private String name;
    private CampaignType type;
    /**
     * ID общего счета или 0, если кампания не подключена к общему счету.
     */
    private Long walletId;
    private Long uid;
    private Long clientId;
    private Long managerUid;
    private Long agencyUid;
    private Long agencyId;
    private CampaignStatusPostmoderate statusPostModerate;
    private CampaignStatusModerate statusModerate;

    private AggregatingSumStatus walletAggregateMigrated;

    private CampaignSource source;

    public CampaignSource getSource() {
        return source;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public CampaignType getType() {
        return type;
    }

    public Long getWalletId() {
        return walletId;
    }

    public Long getUid() {
        return uid;
    }

    public Long getManagerUid() {
        return managerUid;
    }

    public Long getAgencyUid() {
        return agencyUid;
    }

    public CampaignStatusPostmoderate getStatusPostModerate() {
        return statusPostModerate;
    }

    public CampaignStatusModerate getStatusModerate() {
        return statusModerate;
    }

    public Long getClientId() {
        return clientId;
    }

    public BigDecimal getSum() {
        return sum;
    }

    public BigDecimal getSumBalance() {
        return sumBalance;
    }

    public BigDecimal getSumSpent() {
        return sumSpent;
    }

    public Long getBalanceTid() {
        return balanceTid;
    }

    public Boolean getStatusShow() {
        return statusShow;
    }

    public Long getSumUnits() {
        return sumUnits;
    }

    public Long getSumSpentUnits() {
        return sumSpentUnits;
    }

    public BigDecimal getCashback() {
        return cashback;
    }

    public BigDecimal getTotalCashback() {
        return totalCashback;
    }

    public Boolean getStatusEmpty() {
        return statusEmpty;
    }

    public Boolean getArchived() {
        return archived;
    }

    public Boolean getStartTimeInFuture() {
        return startTimeInFuture;
    }

    public Long getProductId() {
        return productId;
    }

    public Long getCmsBalanceTid() {
        return cmsBalanceTid;
    }

    public BigDecimal getCmsSum() {
        return cmsSum;
    }

    public BigDecimal getCmsChipsCost() {
        return cmsChipsCost;
    }

    public BigDecimal getCmsChipsSpent() {
        return cmsChipsSpent;
    }

    public CurrencyCode getCurrency() {
        return currency;
    }

    public Boolean getFirstAfterCopyConvert() {
        return firstAfterCopyConvert;
    }

    public Boolean getCurrencyConverted() {
        return currencyConverted;
    }

    public String getEmail() {
        return email;
    }

    public String getFio() {
        return fio;
    }

    public String getLogin() {
        return login;
    }

    public String getPhone() {
        return phone;
    }

    public Long getStartTimeTs() {
        return startTimeTs;
    }

    public LocalDate getFinishDate() {
        return finishDate;
    }

    public String getLang() {
        return lang;
    }

    public Boolean getPaidByCertificate() {
        return paidByCertificate;
    }

    public Long getTotalBalanceTid() {
        return totalBalanceTid;
    }

    public BigDecimal getTotalSum() {
        return totalSum;
    }

    public CurrencyCode getClientWorkCurrency() {
        return clientWorkCurrency;
    }

    public Long getOrderId() {
        return orderId;
    }

    public String getName() {
        return name;
    }

    public Long getAgencyId() {
        return agencyId;
    }

    public AggregatingSumStatus getWalletAggregateMigrated() {
        return walletAggregateMigrated;
    }

    public CampaignDataForNotifyOrder withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public CampaignDataForNotifyOrder withType(CampaignType type) {
        this.type = type;
        return this;
    }

    public CampaignDataForNotifyOrder withWalletId(Long walletId) {
        this.walletId = walletId;
        return this;
    }

    public CampaignDataForNotifyOrder withUid(Long uid) {
        this.uid = uid;
        return this;
    }

    public CampaignDataForNotifyOrder withManagerUid(Long managerUid) {
        this.managerUid = managerUid;
        return this;
    }

    public CampaignDataForNotifyOrder withAgencyUid(Long agencyUid) {
        this.agencyUid = agencyUid;
        return this;
    }

    public CampaignDataForNotifyOrder withStatusPostModerate(CampaignStatusPostmoderate statusPostModerate) {
        this.statusPostModerate = statusPostModerate;
        return this;
    }

    public CampaignDataForNotifyOrder withStatusModerate(CampaignStatusModerate statusModerate) {
        this.statusModerate = statusModerate;
        return this;
    }

    public CampaignDataForNotifyOrder withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public CampaignDataForNotifyOrder withSum(BigDecimal sum) {
        this.sum = sum;
        return this;
    }

    public CampaignDataForNotifyOrder withSumBalance(BigDecimal sumBalance) {
        this.sumBalance = sumBalance;
        return this;
    }

    public CampaignDataForNotifyOrder withSumSpent(BigDecimal sumSpent) {
        this.sumSpent = sumSpent;
        return this;
    }

    public CampaignDataForNotifyOrder withCashback(BigDecimal cashback) {
        this.cashback = cashback;
        return this;
    }

    public CampaignDataForNotifyOrder withTotalCashback(BigDecimal totalCashback) {
        this.totalCashback = totalCashback;
        return this;
    }

    public CampaignDataForNotifyOrder withBalanceTid(Long balanceTid) {
        this.balanceTid = balanceTid;
        return this;
    }

    public CampaignDataForNotifyOrder withOrderId(Long orderId) {
        this.orderId = orderId;
        return this;
    }

    public CampaignDataForNotifyOrder withName(String name) {
        this.name = name;
        return this;
    }

    public CampaignDataForNotifyOrder withStatusShow(Boolean statusShow) {
        this.statusShow = statusShow;
        return this;
    }

    public CampaignDataForNotifyOrder withSumUnits(Long sumUnits) {
        this.sumUnits = sumUnits;
        return this;
    }

    public CampaignDataForNotifyOrder withSumSpentUnits(Long sumSpentUnits) {
        this.sumSpentUnits = sumSpentUnits;
        return this;
    }

    public CampaignDataForNotifyOrder withStatusEmpty(Boolean statusEmpty) {
        this.statusEmpty = statusEmpty;
        return this;
    }

    public CampaignDataForNotifyOrder withArchived(Boolean archived) {
        this.archived = archived;
        return this;
    }

    public CampaignDataForNotifyOrder withStartTimeInFuture(Boolean startTimeInFuture) {
        this.startTimeInFuture = startTimeInFuture;
        return this;
    }

    public CampaignDataForNotifyOrder withProductId(Long productId) {
        this.productId = productId;
        return this;
    }

    public CampaignDataForNotifyOrder withCmsBalanceTid(Long cmsBalanceTid) {
        this.cmsBalanceTid = cmsBalanceTid;
        return this;
    }

    public CampaignDataForNotifyOrder withCmsSum(BigDecimal cmsSum) {
        this.cmsSum = cmsSum;
        return this;
    }

    public CampaignDataForNotifyOrder withCmsChipsCost(BigDecimal cmsChipsCost) {
        this.cmsChipsCost = cmsChipsCost;
        return this;
    }

    public CampaignDataForNotifyOrder withCmsChipsSpent(BigDecimal cmsChipsSpent) {
        this.cmsChipsSpent = cmsChipsSpent;
        return this;
    }

    public CampaignDataForNotifyOrder withCurrency(CurrencyCode currency) {
        this.currency = currency;
        return this;
    }

    public CampaignDataForNotifyOrder withFirstAfterCopyConvert(Boolean firstAfterCopyConvert) {
        this.firstAfterCopyConvert = firstAfterCopyConvert;
        return this;
    }

    public CampaignDataForNotifyOrder withCurrencyConverted(Boolean currencyConverted) {
        this.currencyConverted = currencyConverted;
        return this;
    }

    public CampaignDataForNotifyOrder withEmail(String email) {
        this.email = email;
        return this;
    }

    public CampaignDataForNotifyOrder withFio(String fio) {
        this.fio = fio;
        return this;
    }

    public CampaignDataForNotifyOrder withLogin(String login) {
        this.login = login;
        return this;
    }

    public CampaignDataForNotifyOrder withPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public CampaignDataForNotifyOrder withStartTimeTs(Long startTimeTs) {
        this.startTimeTs = startTimeTs;
        return this;
    }

    public CampaignDataForNotifyOrder withFinishDate(LocalDate finishDate) {
        this.finishDate = finishDate;
        return this;
    }

    public CampaignDataForNotifyOrder withLang(String lang) {
        this.lang = lang;
        return this;
    }

    public CampaignDataForNotifyOrder withPaidByCertificate(Boolean paidByCertificate) {
        this.paidByCertificate = paidByCertificate;
        return this;
    }

    public CampaignDataForNotifyOrder withTotalBalanceTid(Long totalBalanceTid) {
        this.totalBalanceTid = totalBalanceTid;
        return this;
    }

    public CampaignDataForNotifyOrder withTotalSum(BigDecimal totalSum) {
        this.totalSum = totalSum;
        return this;
    }

    public CampaignDataForNotifyOrder withClientWorkCurrency(CurrencyCode clientWorkCurrency) {
        this.clientWorkCurrency = clientWorkCurrency;
        return this;
    }

    public CampaignDataForNotifyOrder withAgencyId(Long agencyId) {
        this.agencyId = agencyId;
        return this;
    }

    public CampaignDataForNotifyOrder withWalletAggregateMigrated(
            AggregatingSumStatus walletAggregateMigrated) {
        this.walletAggregateMigrated = walletAggregateMigrated;
        return this;
    }

    public CampaignDataForNotifyOrder withSource(CampaignSource source) {
        this.source = source;
        return this;
    }
}
