package ru.yandex.direct.intapi.entity.balanceclient.container;

import java.math.BigDecimal;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.campaign.model.StatusMail;

public class NotifyOrderDbCampaignChanges {
    private BigDecimal sum;
    private BigDecimal sumBalance;
    private BigDecimal sumSpent;
    private BigDecimal sumLast;
    private BigDecimal sumToPay;
    private StatusMail statusMail;
    private Long sumUnits;
    private BigDecimal cashback;
    private BigDecimal totalCashback;
    private Long balanceTid;
    private boolean paidByCertificate = false;
    private boolean resetStatusBsSynced = false;
    private boolean changed = false;

    @Nullable
    public BigDecimal getSum() {
        return sum;
    }

    @Nullable
    public BigDecimal getSumBalance() {
        return sumBalance;
    }

    @Nullable
    public Long getSumUnits() {
        return sumUnits;
    }

    @Nullable
    public BigDecimal getSumSpent() {
        return sumSpent;
    }

    @Nullable
    public BigDecimal getSumLast() {
        return sumLast;
    }

    @Nullable
    public BigDecimal getSumToPay() {
        return sumToPay;
    }

    @Nullable
    public BigDecimal getCashback() {
        return cashback;
    }

    @Nullable
    public BigDecimal getTotalCashback() {
        return totalCashback;
    }

    @Nullable
    public StatusMail getStatusMail() {
        return statusMail;
    }

    @Nullable
    public Long getBalanceTid() {
        return balanceTid;
    }

    public boolean isPaidByCertificate() {
        return paidByCertificate;
    }

    public boolean needResetStatusBsSynced() {
        return resetStatusBsSynced;
    }

    public boolean isChanged() {
        return changed;
    }

    public void setSum(BigDecimal sum) {
        this.sum = sum;
        changed = true;
    }

    public void setSumBalance(BigDecimal sumBalance) {
        this.sumBalance = sumBalance;
        changed = true;
    }

    public void setSumUnits(Long sumUnits) {
        this.sumUnits = sumUnits;
        changed = true;
    }

    public void setSumSpent(BigDecimal sumSpent) {
        this.sumSpent = sumSpent;
        changed = true;
    }

    public void setSumLast(BigDecimal sumLast) {
        this.sumLast = sumLast;
        changed = true;
    }

    public void setSumToPay(BigDecimal sumToPay) {
        this.sumToPay = sumToPay;
        changed = true;
    }

    public void setCashback(BigDecimal cashback) {
        this.cashback = cashback;
        changed = true;
    }

    public void setTotalCashback(BigDecimal totalCashback) {
        this.totalCashback = totalCashback;
        changed = true;
    }

    public void setStatusMail(StatusMail statusMail) {
        this.statusMail = statusMail;
        changed = true;
    }

    public void setBalanceTid(Long balanceTid) {
        this.balanceTid = balanceTid;
        changed = true;
    }

    public void setPaidByCertificate() {
        paidByCertificate = true;
        changed = true;
    }

    public void resetStatusBsSynced() {
        resetStatusBsSynced = true;
        changed = true;
    }

    public NotifyOrderDbCampaignChanges withSum(BigDecimal sum) {
        this.sum = sum;
        return this;
    }

    public NotifyOrderDbCampaignChanges withSumBalance(BigDecimal sumBalance) {
        this.sumBalance = sumBalance;
        return this;
    }

    public NotifyOrderDbCampaignChanges withSumSpent(BigDecimal sumSpent) {
        this.sumSpent = sumSpent;
        return this;
    }

    public NotifyOrderDbCampaignChanges withSumLast(BigDecimal sumLast) {
        this.sumLast = sumLast;
        return this;
    }

    public NotifyOrderDbCampaignChanges withSumToPay(BigDecimal sumToPay) {
        this.sumToPay = sumToPay;
        return this;
    }

    public NotifyOrderDbCampaignChanges withStatusMail(StatusMail statusMail) {
        this.statusMail = statusMail;
        return this;
    }

    public NotifyOrderDbCampaignChanges withSumUnits(Long sumUnits) {
        this.sumUnits = sumUnits;
        return this;
    }

    public NotifyOrderDbCampaignChanges withBalanceTid(Long balanceTid) {
        this.balanceTid = balanceTid;
        return this;
    }

    public NotifyOrderDbCampaignChanges withPaidByCertificate(boolean paidByCertificate) {
        this.paidByCertificate = paidByCertificate;
        return this;
    }

    public NotifyOrderDbCampaignChanges withResetStatusBsSynced(boolean resetStatusBsSynced) {
        this.resetStatusBsSynced = resetStatusBsSynced;
        return this;
    }

    public NotifyOrderDbCampaignChanges withChanged(boolean changed) {
        this.changed = changed;
        return this;
    }
}
