package ru.yandex.direct.intapi.entity.balanceclient.exception;

import ru.yandex.direct.intapi.entity.balanceclient.container.BalanceClientResponse;

/**
 * Исключение предназначено только для прокидывания ошибки из сервиса сразу в ответ балансу.
 * Оптимизировано засчет отключения заполнения стек-трейса
 */
public class BalanceClientException extends RuntimeException {

    /**
     * Конструктор исключения
     *
     * @param message текст сообщения, которое будет прокинуто в ошибку балансу
     */
    public BalanceClientException(String message) {
        super(message, null, false, false);
    }

    /**
     * Получить ошибочный ответ балансу с сообщением, указанным в конструкторе
     *
     * @return {@link BalanceClientResponse#criticalError(String)}
     */
    public BalanceClientResponse getResponse() {
        return BalanceClientResponse.criticalError(getMessage());
    }
}
