package ru.yandex.direct.intapi.entity.balanceclient.model;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
@JsonFormat(shape = JsonFormat.Shape.ARRAY)
@JsonPropertyOrder({BalanceClientResult.RESPONSE_CODE_FIELD_NAME, BalanceClientResult.RESPONSE_MESSAGE_FIELD_NAME})
public class BalanceClientResult {
    public static final int OK_CODE = 0;
    public static final int INTERNAL_ERROR_CODE = -32603;
    public static final String RESPONSE_CODE_FIELD_NAME = "responseCode";
    public static final String RESPONSE_MESSAGE_FIELD_NAME = "responseMessage";

    private final int responseCode;
    private final String responseMessage;

    public BalanceClientResult(int responseCode, @Nonnull String responseMessage) {
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
    }

    @ApiModelProperty(required = true, value = "Код возврата")
    @JsonGetter(RESPONSE_CODE_FIELD_NAME)
    public int getResponseCode() {
        return responseCode;
    }

    @ApiModelProperty(required = true, value = "Строковое описание результата")
    @JsonGetter(RESPONSE_MESSAGE_FIELD_NAME)
    public String getResponseMessage() {
        return responseMessage;
    }

    @JsonCreator
    public static BalanceClientResult fromJson(JsonNode node) {
        if (!node.isArray()) {
            throw new IllegalArgumentException();
        }
        int code = Preconditions.checkNotNull(node.get(0).asInt());
        String message = Preconditions.checkNotNull(node.get(1).textValue());
        return new BalanceClientResult(code, message);
    }
}
