package ru.yandex.direct.intapi.entity.balanceclient.model;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Информация о промокоде.
 * Обязательными отмечены используемые нами поля. При этом биллинг присылает все.
 *
 * @see <a href="https://st.yandex-team.ru/BALANCE-28045">BALANCE-28045: Антифрод по промокодам Директа</a>
 */
@ApiModel(value = "Информация о промокоде")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY,
        getterVisibility = JsonAutoDetect.Visibility.NONE,
        setterVisibility = JsonAutoDetect.Visibility.NONE,
        creatorVisibility = JsonAutoDetect.Visibility.NONE
)
public class BalancePromocodeInfo {
    public static final String PROMOCODE_ID_FIELD_NAME = "PromocodeID";
    public static final String NEED_UNIQUE_URLS_FIELD_NAME = "NeedUniqueUrls";
    public static final String START_DATE_TIME_FIELD_NAME = "StartDt";
    public static final String AVAILABLE_PROMOCODE_QTY_FIELD_NAME = "AvailablePromocodeQty";

    @JsonProperty(value = PROMOCODE_ID_FIELD_NAME, required = true)
    @ApiModelProperty(value = "Идентификатор промокода", required = true, example = "2124306")
    private Long id;

    @JsonProperty(value = "PromocodeCode")
    @ApiModelProperty(value = "Промокод", example = "ALD7RUD6QCBWJEQ3")
    private String code;

    @JsonProperty(value = "UnusedPromocodeQty")
    @ApiModelProperty(value = "Зачисленные бонусы от промокода", example = "23276.5620")
    private BigDecimal unusedQty;

    @JsonProperty(value = AVAILABLE_PROMOCODE_QTY_FIELD_NAME)
    @ApiModelProperty(value = "Свободные незаакченные промокодные средства", example = "23276.5620")
    private BigDecimal availableQty;

    @JsonProperty(value = "InvoiceEID")
    @ApiModelProperty(value = "Внешний идентификатор счёта", example = "Б-66434259-1")
    private String invoiceExternalId;

    @JsonProperty(value = "InvoiceID")
    @ApiModelProperty(value = "Идентификатор счёта", example = "46834292")
    private Long invoiceId;

    @JsonProperty(value = "AnySameSeries")
    @ApiModelProperty(value = "Применимость: /нет описания, предположительно не используется/", example = "false")
    private Boolean anySameSeries;

    @JsonProperty(value = "IsGlobalUnique")
    @ApiModelProperty(value = "Применимость: может быть использован только один раз", example = "true")
    private Boolean globalUnique;

    @JsonProperty(value = NEED_UNIQUE_URLS_FIELD_NAME, required = true)
    @ApiModelProperty(value = "Применимость: требуется уникальность клиента по доменам",
            required = true, example = "true")
    private Boolean uniqueUrlNeeded;

    @JsonProperty(value = "NewClientsOnly")
    @ApiModelProperty(value = "Применимость: у клиента не должно быть актов/услуг в течение года", example = "true")
    private Boolean forNewClientsOnly;

    @JsonProperty(value = START_DATE_TIME_FIELD_NAME, required = true)
    @ApiModelProperty(value = "Дата и время включения счёта", required = true, example = "2015-12-08T19:29:37")
    private LocalDateTime invoiceEnabledAt;

    public Long getId() {
        return id;
    }

    public Boolean getUniqueUrlNeeded() {
        return uniqueUrlNeeded;
    }

    public LocalDateTime getInvoiceEnabledAt() {
        return invoiceEnabledAt;
    }

    public String getCode() {
        return code;
    }

    public String getInvoiceExternalId() {
        return invoiceExternalId;
    }

    public Long getInvoiceId() {
        return invoiceId;
    }

    public BigDecimal getAvailableQty() {
        return availableQty;
    }

    public Boolean getForNewClientsOnly() {
        return forNewClientsOnly;
    }

    public BalancePromocodeInfo withUniqueUrlNeeded(Boolean uniqueUrlNeeded) {
        this.uniqueUrlNeeded = uniqueUrlNeeded;
        return this;
    }

    public BalancePromocodeInfo withInvoiceEnabledAt(LocalDateTime invoiceEnabledAt) {
        this.invoiceEnabledAt = invoiceEnabledAt;
        return this;
    }

    public BalancePromocodeInfo withId(Long id) {
        this.id = id;
        return this;
    }

    public BalancePromocodeInfo withCode(String code) {
        this.code = code;
        return this;
    }

    public BalancePromocodeInfo withUnusedQty(BigDecimal currentQty) {
        this.unusedQty = currentQty;
        return this;
    }

    public BalancePromocodeInfo withInvoiceExternalId(String invoiceExternalId) {
        this.invoiceExternalId = invoiceExternalId;
        return this;
    }

    public BalancePromocodeInfo withInvoiceId(Long invoiceId) {
        this.invoiceId = invoiceId;
        return this;
    }

    public BalancePromocodeInfo withAnySameSeries(Boolean anySameSeries) {
        this.anySameSeries = anySameSeries;
        return this;
    }

    public BalancePromocodeInfo withGlobalUnique(Boolean globalUnique) {
        this.globalUnique = globalUnique;
        return this;
    }

    public BalancePromocodeInfo withForNewClientsOnly(Boolean forNewClientsOnly) {
        this.forNewClientsOnly = forNewClientsOnly;
        return this;
    }

    public BalancePromocodeInfo withAvailableQty(BigDecimal availableQty) {
        this.availableQty = availableQty;
        return this;
    }
}
