package ru.yandex.direct.intapi.entity.balanceclient.model;

import java.util.Set;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
@JsonPropertyOrder({BalanceClientResult.RESPONSE_CODE_FIELD_NAME, BalanceClientResult.RESPONSE_MESSAGE_FIELD_NAME})
public class GetHostingsResult {
    private static final String RESPONSE_HOSTINGS_LIST = "hostings";
    private static final String RESPONSE_PUBLIC_SECOND_LEVEL_DOMAINS_LIST = "pub2ld";
    private final Set<String> hostings;
    private final Set<String> publicSecondLevelDomains;

    public GetHostingsResult(Set<String> hostings, Set<String> publicSecondLevelDomains) {
        this.hostings = hostings;
        this.publicSecondLevelDomains = publicSecondLevelDomains;
    }

    @ApiModelProperty(required = true, value = "Список известных хостинг-площадок")
    @JsonGetter(RESPONSE_HOSTINGS_LIST)
    public Set<String> getHostings() {
        return hostings;
    }

    @ApiModelProperty(required = true, value = "Список известных доменов второго уровня")
    @JsonGetter(RESPONSE_PUBLIC_SECOND_LEVEL_DOMAINS_LIST)
    public Set<String> getPublicSecondLevelDomains() {
        return publicSecondLevelDomains;
    }
}
