package ru.yandex.direct.intapi.entity.balanceclient.model;

import java.time.LocalDate;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

public class NotifyAgencyAdditionalCurrenciesItem {
    @ApiModelProperty(value = "Код валюты", required = true, example = "RUB")
    @JsonProperty(value = "Currency", required = true)
    private String currencyCode;

    @ApiModelProperty(value = "Дата истечения дополнительного соглашения по валюте",
            required = true, example = "2012-06-30")
    @JsonProperty(value = "ExpireDate", required = true)
    private LocalDate expireDate;

    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public NotifyAgencyAdditionalCurrenciesItem withCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    public LocalDate getExpireDate() {
        return expireDate;
    }

    public void setExpireDate(LocalDate expireDate) {
        this.expireDate = expireDate;
    }

    public NotifyAgencyAdditionalCurrenciesItem withExpireDate(LocalDate expireDate) {
        this.expireDate = expireDate;
        return this;
    }
}
