package ru.yandex.direct.intapi.entity.balanceclient.model;

import java.math.BigDecimal;
import java.util.StringJoiner;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Модель, описывающая балансовую нотификацию об изменении кэшбека у клиента
 *
 * @see <a href="https://st.yandex-team.ru/BALANCE-34923">BALANCE-34923: [Директ] Cashback</a>
 * @see <a href="https://st.yandex-team.ru/BILLINGPLAN-605">BILLINGPLAN-605: Изменение ручки</a>
 */
@ApiModel
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY,
        getterVisibility = JsonAutoDetect.Visibility.NONE,
        setterVisibility = JsonAutoDetect.Visibility.NONE,
        creatorVisibility = JsonAutoDetect.Visibility.NONE
)
public class NotifyClientCashBackParameters {

    public static final String CASH_BACK_CONSUMED_BONUS_FIELD_NAME = "ConsumedBonus";
    public static final String CASH_BACK_BONUS_FIELD_NAME = "Bonus";
    public static final String CURRENCY_FIELD_NAME = "IsoCurrency";

    // для этой нотификации id клиента и сервиса приходят в таком виде
    public static final String CLIENT_ID_FIELD_NAME = "ClientID";
    public static final String SERVICE_ID_FIELD_NAME = "ServiceID";

    @ApiModelProperty(value = "Идентификатор клиента", required = true, example = "15155")
    @JsonProperty(value = CLIENT_ID_FIELD_NAME, required = true)
    private Long clientId;

    @ApiModelProperty(value = "Идентификатор сервиса", required = true, example = "7")
    @JsonProperty(value = SERVICE_ID_FIELD_NAME, required = true)
    private Integer serviceId;

    @ApiModelProperty(value = "валюта кэшбека", required = true, example = "RUB")
    @JsonProperty(value = CURRENCY_FIELD_NAME)
    private String balanceCurrency;

    @ApiModelProperty(value = "сумма кэшбека", required = true, example = "100500")
    @JsonProperty(value = CASH_BACK_BONUS_FIELD_NAME)
    private BigDecimal cashbackBonus;

    @ApiModelProperty(value = "сумма активированного кэшбека", required = true, example = "100500")
    @JsonProperty(value = CASH_BACK_CONSUMED_BONUS_FIELD_NAME)
    private BigDecimal cashbackConsumedBonus;

    public Long getClientId() {
        return clientId;
    }

    public Integer getServiceId() {
        return serviceId;
    }

    public String getBalanceCurrency() {
        return balanceCurrency;
    }

    public BigDecimal getCashBackBonus() {
        return cashbackBonus;
    }

    public BigDecimal getCashbackConsumedBonus() {
        return cashbackConsumedBonus;
    }

    public NotifyClientCashBackParameters withServiceId(Integer serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public NotifyClientCashBackParameters withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public NotifyClientCashBackParameters withBalanceCurrency(String balanceCurrency) {
        this.balanceCurrency = balanceCurrency;
        return this;
    }

    public NotifyClientCashBackParameters withCashBackBonus(BigDecimal cashbackBonus) {
        this.cashbackBonus = cashbackBonus;
        return this;
    }

    public NotifyClientCashBackParameters withCashbackConsumedBonus(BigDecimal cashbackConsumedBonus) {
        this.cashbackConsumedBonus = cashbackConsumedBonus;
        return this;
    }


    @Override
    public String toString() {
        return new StringJoiner(", ", NotifyClientCashBackParameters.class.getSimpleName() + "[", "]")
                .add("clientId=" + clientId)
                .add("serviceId=" + serviceId)
                .add("balanceCurrency='" + balanceCurrency + "'")
                .add("cashbackBonus=" + cashbackBonus)
                .add("cashbackConsumedBonus=" + cashbackConsumedBonus)
                .toString();
    }

}
