package ru.yandex.direct.intapi.entity.balanceclient.model;

import java.math.BigDecimal;
import java.time.LocalDate;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.direct.utils.ZeroDateAwareDeserializer;

import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.ANY;
import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.NONE;
import static com.google.common.base.Strings.isNullOrEmpty;
import static org.apache.commons.lang3.BooleanUtils.toBooleanObject;
import static org.apache.commons.lang3.BooleanUtils.toInteger;

@ApiModel
@JsonAutoDetect(fieldVisibility = ANY, getterVisibility = NONE, setterVisibility = NONE, isGetterVisibility = NONE)
public class NotifyClientParameters {
    public static final String CLIENT_ID_FIELD_NAME = "ClientID";

    @ApiModelProperty(required = true, example = "15155")
    @JsonProperty(value = CLIENT_ID_FIELD_NAME, required = true)
    private Long clientId;

    @ApiModelProperty(value = "возрастающий номер транзакции, для отсечения уже применённых нотификаций",
            required = true, example = "20170329012114000")
    @JsonProperty(value = "Tid", required = true)
    private Long tid;

    @ApiModelProperty(notes = "предел овердрафта", required = true, example = "666.66")
    @JsonProperty("OverdraftLimit")
    private BigDecimal overdraftLimit;

    @ApiModelProperty(notes = "сумма текущего долга", required = true, example = "555.55")
    @JsonProperty("OverdraftSpent")
    private BigDecimal overdraftSpent;

    @ApiModelProperty(value = "дата следующего платежа по овердрафту; Значение 0000-00-00 интерпретируется как null")
    @JsonDeserialize(using = ZeroDateAwareDeserializer.class)
    @JsonProperty("MinPaymentTerm")
    private LocalDate nextPayDate;

    @ApiModelProperty("Забанен ли клиент в Балансе (не используется)")
    @JsonProperty("OverdraftBan")
    private Integer statusBalanceBanned;

    @ApiModelProperty(value = "валюта клиента", example = "RUB")
    @JsonProperty("ClientCurrency")
    private String balanceCurrency;

    @ApiModelProperty("является ли клиент резидентом")
    @JsonProperty("NonResident")
    private Integer isNonResident;

    @ApiModelProperty("клиент является представителем одного из бизнес-юнитов Яндекса")
    @JsonProperty("BusinessUnit")
    private Integer isBusinessUnit;

    @ApiModelProperty("клиент является брендом")
    @JsonProperty("HasEquivalentOrBrandClients")
    private Integer isBrand;

    @ApiModelProperty("признак окончания в Балансе конвертационных процессов " +
            "(компенсация по ОС, пересчёт овердрафта, …)")
    @JsonProperty("MigrateToCurrencyDone")
    private Integer migrateToCurrencyDone;

    @ApiModelProperty("клиент подтвердил оферту, позволяющую сконвертировать его принудительно в валюту")
    @JsonProperty("CanBeForceCurrencyConverted")
    private Integer canBeForceCurrencyConverted;

    public Long getClientId() {
        return clientId;
    }

    public Long getTid() {
        return tid;
    }

    public BigDecimal getOverdraftLimit() {
        return overdraftLimit;
    }

    public BigDecimal getOverdraftSpent() {
        return overdraftSpent;
    }

    public LocalDate getNextPayDate() {
        return nextPayDate;
    }

    public Boolean getStatusBalanceBanned() {
        return toBooleanObject(statusBalanceBanned);
    }

    public String getBalanceCurrency() {
        return isNullOrEmpty(balanceCurrency) ? null : balanceCurrency;
    }

    public Boolean isNonResident() {
        return toBooleanObject(isNonResident);
    }

    public Boolean isBusinessUnit() {
        return toBooleanObject(isBusinessUnit);
    }

    public Boolean isBrand() {
        return toBooleanObject(isBrand);
    }

    public Boolean getMigrateToCurrencyDone() {
        return toBooleanObject(migrateToCurrencyDone);
    }

    public Boolean getCanBeForceCurrencyConverted() {
        return toBooleanObject(canBeForceCurrencyConverted);
    }

    public NotifyClientParameters withClientId(final Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public NotifyClientParameters withTid(final Long tid) {
        this.tid = tid;
        return this;
    }

    public NotifyClientParameters withOverdraftLimit(final BigDecimal overdraftLimit) {
        this.overdraftLimit = overdraftLimit;
        return this;
    }

    public NotifyClientParameters withOverdraftSpent(final BigDecimal overdraftSpent) {
        this.overdraftSpent = overdraftSpent;
        return this;
    }

    public NotifyClientParameters withNextPayDate(final LocalDate nextPayDate) {
        this.nextPayDate = nextPayDate;
        return this;
    }

    public NotifyClientParameters withStatusBalanceBanned(boolean statusBalanceBanned) {
        this.statusBalanceBanned = toInteger(statusBalanceBanned);
        return this;
    }

    public NotifyClientParameters withBalanceCurrency(final String balanceCurrency) {
        this.balanceCurrency = balanceCurrency;
        return this;
    }

    public NotifyClientParameters withIsNonResident(boolean isNonResident) {
        this.isNonResident = toInteger(isNonResident);
        return this;
    }

    public NotifyClientParameters withIsBusinessUnit(boolean isBusinessUnit) {
        this.isBusinessUnit = toInteger(isBusinessUnit);
        return this;
    }

    public NotifyClientParameters withIsBrand(boolean isBrand) {
        this.isBrand = toInteger(isBrand);
        return this;
    }

    public NotifyClientParameters withMigrateToCurrencyDone(boolean migrateToCurrencyDone) {
        this.migrateToCurrencyDone = toInteger(migrateToCurrencyDone);
        return this;
    }

    public NotifyClientParameters withCanBeForceCurrencyConverted(boolean canBeForceCurrencyConverted) {
        this.canBeForceCurrencyConverted = toInteger(canBeForceCurrencyConverted);
        return this;
    }


}
