package ru.yandex.direct.intapi.entity.balanceclient.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import static ru.yandex.direct.intapi.entity.balanceclient.model.NotifyOrderParameters.CAMPAIGN_ID_FIELD_NAME;
import static ru.yandex.direct.intapi.entity.balanceclient.model.NotifyOrderParameters.SERVICE_ID_FIELD_NAME;

/**
 * Модель, описывающая балансовую нотификацию об изменении состава промокодных средств на заказе
 *
 * @see <a href="https://st.yandex-team.ru/BALANCE-28045">BALANCE-28045: Антифрод по промокодам Директа</a>
 */
@ApiModel
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY,
        getterVisibility = JsonAutoDetect.Visibility.NONE,
        setterVisibility = JsonAutoDetect.Visibility.NONE,
        creatorVisibility = JsonAutoDetect.Visibility.NONE
)
public class NotifyPromocodeParameters {
    public static final String PROMOCODES_FIELD_NAME = "Promocodes";

    /**
     * Код сервиса
     */
    @JsonProperty(value = SERVICE_ID_FIELD_NAME, required = true)
    @ApiModelProperty(value = "Идентификатор сервиса", required = true, example = "7")
    private Integer serviceId;

    /**
     * Номер кампании в директе
     */
    @JsonProperty(value = CAMPAIGN_ID_FIELD_NAME, required = true)
    @ApiModelProperty(value = "Идентификатор кампании (заказа) на сервисе", required = true, example = "263")
    private Long campaignId;

    /**
     * Список актуальных промокодов
     */
    @JsonProperty(value = PROMOCODES_FIELD_NAME, required = true)
    @ApiModelProperty(value = "Полная информация по действующим промокодам", required = true)
    private List<BalancePromocodeInfo> promocodes;

    public Integer getServiceId() {
        return serviceId;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public List<BalancePromocodeInfo> getPromocodes() {
        return promocodes;
    }

    public NotifyPromocodeParameters withServiceId(Integer serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public NotifyPromocodeParameters withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public NotifyPromocodeParameters withPromocodes(List<BalancePromocodeInfo> promocodes) {
        this.promocodes = promocodes;
        return this;
    }
}
