package ru.yandex.direct.intapi.entity.balanceclient.repository;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.SMS_QUEUE;

@Repository
public class CashbackNotificationsRepository {
    // При добавлении в очередь из джавы переводы берутся другим механизмом, поэтому в sms_queue запишем значение,
    // которого нет в папке с шаблонами https://a.yandex-team.ru/arc/trunk/arcadia/direct/perl/data/t/emails/ru
    private static final String TEMPLATE_NAME = "cashback_consumed_notification_sms";

    private final DslContextProvider dslContextProvider;

    @Autowired
    public CashbackNotificationsRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    public void addCashbackSmsNotification(int shard, ClientId clientId, Long uid, Long walletId, String message) {
        dslContextProvider.ppc(shard)
                .insertInto(SMS_QUEUE)
                .columns(SMS_QUEUE.UID, SMS_QUEUE.SMS_TEXT, SMS_QUEUE.CID, SMS_QUEUE.TEMPLATE_NAME)
                .values(uid, message, walletId, TEMPLATE_NAME)
                .execute();
    }
}
