package ru.yandex.direct.intapi.entity.balanceclient.service;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.core.entity.campaign.repository.WalletRepository;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.intapi.entity.balanceclient.repository.CashbackNotificationsRepository;
import ru.yandex.direct.rbac.RbacService;

import static ru.yandex.direct.utils.CommonUtils.nvl;

/**
 * Сервис уведомлений клиента о поступившем кешбеке
 */
@ParametersAreNonnullByDefault
@Service
public class CashbackNotificationsService {
    private final TranslationService translationService;
    private final FeatureService featureService;
    private final RbacService rbacService;
    private final WalletRepository walletRepository;
    private final CashbackNotificationsRepository cashbackNotificationsRepository;
    private final ShardHelper shardHelper;

    @Autowired
    public CashbackNotificationsService(TranslationService translationService,
                                        FeatureService featureService,
                                        RbacService rbacService,
                                        WalletRepository walletRepository,
                                        CashbackNotificationsRepository cashbackNotificationsRepository,
                                        ShardHelper shardHelper) {
        this.translationService = translationService;
        this.featureService = featureService;
        this.rbacService = rbacService;
        this.walletRepository = walletRepository;
        this.cashbackNotificationsRepository = cashbackNotificationsRepository;
        this.shardHelper = shardHelper;
    }

    public void addSmsNotification(ClientId clientId, BigDecimal cashbackBonus, CurrencyCode currencyCode) {
        var clientFeatures = featureService.getEnabledForClientId(clientId);
        if (!clientFeatures.contains(FeatureName.CASHBACK_SMS_NOTIFICATIONS_ENABLED.getName())) {
            return;
        }

        var shard = shardHelper.getShardByClientIdStrictly(clientId);
        var walletCid = nvl(walletRepository.getActualClientWalletId(shard, clientId, currencyCode), 0L);

        Map<ClientId, Long> chiefUidsByClientIds = rbacService.getChiefsByClientIds(Set.of(clientId));
        var message = translationService
                .translate(CashbackTranslations.INSTANCE.consumedCashbackBonusUpdated(cashbackBonus));
        chiefUidsByClientIds.forEach((chiefClientId, uid) ->
                cashbackNotificationsRepository.addCashbackSmsNotification(shard, clientId, uid, walletCid, message));
    }
}
