package ru.yandex.direct.intapi.entity.balanceclient.service.migration;

import ru.yandex.direct.redislock.DistributedLock;

import static com.google.common.base.Preconditions.checkState;

@SuppressWarnings("checkstyle:linelength")
/**
 * Доступные состоянии при получении нотификаций из биллинга.
 * <p>
 * При обработке кампаний с общим счётом высчитываем как обрабатываем деньги:
 * по старой или новой схеме или пока не можем обработать.
 * <p>
 * https://wiki.yandex-team.ru/users/andreymak/new-sums-under-wallet/#adaptacijanotifyorder2krabotevnovojjsxemeiperevodustaryxobshhixschetovnanovujusxemu
 */
public class MigrationSchema {

    public enum State {
        /*
          Существующая схема записи денег из биллинга
         */
        OLD,

        /*
         Новая схема записи денег из биллинга
         */
        NEW,

        /*
         Проблемы при взятии лока на общий счёт кампании.
         */
        LOCK_TROUBLES,

        /*
         Старая схема обработки, но с локом на общем счёте, чтобы другие компоненты не начали параллельно миграцию.
         */
        OLD_WITH_LOCK;
    }

    private State state;
    private DistributedLock lock;

    public State getState() {
        return state;
    }

    public MigrationSchema withState(State state) {
        this.state = state;
        return this;
    }

    public DistributedLock getLock() {
        return lock;
    }

    public static MigrationSchema build(State state) {
        return new MigrationSchema().withState(state);
    }


    public MigrationSchema withLock(DistributedLock lock) {
        checkState(state == State.OLD_WITH_LOCK, "state %s doesn't support locks", state.name());
        this.lock = lock;

        return this;
    }
}
