package ru.yandex.direct.intapi.entity.banner.presentation;

import ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectTranslations;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.core.validation.defects.params.ModelIdDefectParams;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;

import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.ACTION_IN_ARCHIVED_CAMPAIGN;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.ADD_TO_ARCHIVED_CAMPAIGN_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.AD_GROUP_NOT_FOUND;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.AD_GROUP_TYPE_NOT_SUPPORTED;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.AD_MORE_THAN_ONCE_IN_REQUEST;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.AD_NOT_FOUND;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.ALREADY_ARCHIVED;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.ALREADY_SUSPENDED;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.ARCHIVED_BANNER_MODIFICATION;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.ARCHIVE_BANNER_SHOWN_IN_BS;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.ARCHIVE_DRAFT_BANNER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.ARRAY_ELEMENT_INVALID_ID;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.BANNER_CANNOT_HAVE_TURBO_GALLERY_HREF;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.BANNER_HREF_IS_INCOMPATIBLE_WITH_PAY_FOR_CONVERSION_STRATEGY;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.BANNER_MODERATE_WITH_EMPTY_GROUP;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.BANNER_PRICE_CURRENCY_MISSING;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.BANNER_PRICE_GREATER_THAN_OLD;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.BANNER_PRICE_MISSING;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.BANNER_SITELINKS_HREF_IS_INCOMPATIBLE_WITH_PAY_FOR_CONVERSION_STRATEGY;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.BANNER_TYPE_MODIFICATION;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CANNOT_CHANGE_BANNER_FLAGS_FROM_AGE_TO_OTHER_TYPES;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CANNOT_CHANGE_BANNER_FLAGS_FROM_BABY_FOOD_TO_OTHER_TYPES;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CANNOT_CHANGE_CREATIVE_ID_TO_IMAGE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CANNOT_CHANGE_IMAGE_TO_CREATIVE_ID;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CANNOT_HAVE_TEMPLATE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CANNOT_HAVE_TURBOLANDINGS;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CANNOT_UPDATE_ARCHIVED_AD;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CLIENT_CANNOT_SET_BANNER_FLAGS;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CLIENT_HAS_NOT_CREATIVES;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CONTENT_PROMOTION_COLLECTION_IS_INACCESSIBLE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CONTENT_PROMOTION_VIDEO_IS_INACCESSIBLE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CONTENT_TYPE_NOT_MATCHES_ADGROUP_CONTENT_TYPE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CPC_VIDEO_NOT_FOUND;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.CREATIVE_NOT_FOUND;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.DIFFERENT_TEMPLATES_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.DUPLICATE_SPECIAL_CHARS_IN_DISPLAY_HREF;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.EMPTY_DISPLAY_HREF;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.EMPTY_HREF;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.EMPTY_VALUE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.ERRORS_WHILE_COPYING_BANNERS;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.FORBIDDEN_MOBILE_BANNER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.FORBIDDEN_TO_CHANGE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.ILLEGAL_COMMA;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.IMAGE_NOT_FOUND;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.IMAGE_SIZE_INVALID;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.IMAGE_SIZE_MODIFICATION;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.IMAGE_SIZE_NOT_FOUND;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INCONSISTENT_BANNER_CID_AND_CAMPAIGN_ID;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INCONSISTENT_BANNER_TYPE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INCONSISTENT_CREATIVE_AND_CPM_VIDEO_AD_GROUP_SKIPPABILITY;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INCONSISTENT_CREATIVE_BUSINESS_TYPE_TO_FEED_BUSINESS_TYPE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INCONSISTENT_CREATIVE_FORMAT;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INCONSISTENT_CREATIVE_GEO_TO_ADGROUP_GEO;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INCONSISTENT_CREATIVE_TYPE_TO_BANNER_TYPE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INCONSISTENT_LEADFORM_HREF_AND_BUTTON_TEXT;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INCONSISTENT_STATE_BANNER_TYPE_AND_ADGROUP_TYPE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INCONSISTENT_STATE_BANNER_TYPE_AND_IMAGE_TYPE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INCONSISTENT_STATE_BANNER_TYPE_AND_TURBOLANDING_TYPE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INCORRECT_IMPRESSION_URL_TRACKER_ID;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INCORRECT_IMPRESSION_URL_TRACKING_SYSTEM;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INSUFFICIENT_RIGHTS;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INTERNAL_TEMPLATE_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INTERNAL_TEMPLATE_VARIABLES_MISMATCH;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INVALID_DISPLAY_HREF_USAGE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INVALID_DOMAIN;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INVALID_HREF;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INVALID_PIXEL_FORMAT;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INVALID_SITELINK_SET_USAGE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.INVALID_TEMPLATE_QUERY;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.IS_NOT_ARCHIVED;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.IS_NOT_SUSPENDED;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.MODERATE_ARCHIVED_BANNER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.MODERATE_BANNER_IN_GROUP_WITHOUT_SHOW_CONDITIONS;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.MODERATE_NON_DRAFT_BANNER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.PRICE_SALES_CAMPAIGN_GEO_OVERLAPS_BANNER_MINUS_GEO;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.PRICE_SALES_DISALLOWED_CREATIVE_TEMPLATE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.PRICE_SALES_FULLNESS_VIOLATED;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REMODERATE_BANNER_IS_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REMODERATE_BANNER_WITH_NO_MOD_REASONS;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REMODERATE_DRAFT_BANNER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REQUIRED_AD_GROUPS_IMPRESSION_RATE_BUT_EMPTY;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REQUIRED_CAMPAIGNS_IMPRESSION_RATE_BUT_EMPTY;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REQUIRED_CAMPAIGN_OR_AD_GROUP_MAX_STOPS_COUNT_BUT_EMPTY;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REQUIRED_CANVAS_OR_HTML5_TYPES;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REQUIRED_CANVAS_TYPE_ONLY;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REQUIRED_CPM_AUDIO_TYPE_ONLY;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REQUIRED_CPM_VIDEO_TYPE_ONLY;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REQUIRED_HREF_OR_TURBOLANDING_ID;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REQUIRED_HREF_OR_VCARD_ID;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REQUIRED_HTML5_TYPE_ONLY;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REQUIRED_IMAGE_HASH_OR_CREATIVE_ID;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REQUIRED_ONLY_IMAGE_OR_CREATIVE_ID;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.REQUIRED_VIDEO_ADDITION_TYPE_ONLY;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.RESTRICTED_CHARS_IN_FIELD;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.RESUME_ARCHIVED_BANNER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.RESUME_DRAFT_BANNER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.SITELINKS_SET_NOT_FOUND;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.SITELINK_DOMAIN_IS_NOT_FIT_TO_BANNER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.SUSPEND_ARCHIVED_BANNER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.SUSPEND_DRAFT_BANNER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.TEMPLATE_MUST_BE_MODERATED;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.TEMPLATE_RESOURCE_ID_NOT_FOUND;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.THIS_TRACKING_SYSTEM_DOMAIN_NOT_SUPPORTED;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.THIS_TRACKING_SYSTEM_DOMAIN_ONLY_SUPPORTS_HTTPS;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.TRACKING_URL_DOESNT_CONTAIN_MACROS;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.TURBO_PAGE_NOT_FOUND;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.UNABLE_TO_DELETE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.UNSUPPORTED_BANNER_TYPE;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.UNSUPPORTED_BUTTON_ACTION;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.VCARD_NOT_FOUND;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.VCARD_OF_ANOTHER_CAMPAIGN;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.VIDEO_EXTENSION_NOT_FOUND;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Id.AD_EXTENSION_NOT_FOUND;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Id.ARCHIVE_IN_ARCHIVED_CAMPAIGN;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Id.DUPLICATED_AD_EXTENSION_ID;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Id.MODERATE_BANNER_IN_ARCHIVED_CAMPAIGN;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Id.REMODERATE_BANNER_IN_DRAFT_CAMPAIGN;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Id.RESUME_IN_ARCHIVED_CAMPAIGN;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Id.SUSPEND_IN_ARCHIVED_CAMPAIGN;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Id.UNARCHIVE_IN_ARCHIVED_CAMPAIGN;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.LanguageDefect.INCONSISTENT_LANGUAGE_WITH_GEO;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.ModReasons.REMODERATE_BANNER_WITH_NOT_ALLOWED_MOD_REASONS;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Num.MAX_BANNERS_IN_ADGROUP;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Num.MAX_BANNERS_IN_INTERNAL_CAMPAIGN;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Num.MAX_BANNERS_IN_UNIVERSAL_APP_CAMPAIGN;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.PixelPermissions.NO_RIGHTS_TO_PIXEL;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.PixelProviderLimits.EQUAL_PIXEL_PROVIDERS;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.PixelWithMeasurer.INVALID_PIXEL_WITH_MEASURER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Price.MUST_BE_GREATER_THAN_MIN;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Price.MUST_BE_LESS_THEN_OR_EQUAL_TO_MAX;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Size.MAX_CALLOUTS_ON_BANNER_ADD;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Size.MAX_CALLOUTS_PER_BANNER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Size.MAX_FOREIGN_PIXELS_ON_BANNER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Size.MAX_YA_AUD_PIXELS_ON_BANNER;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.String.DISPLAY_HREF_LENGTH_CANNOT_BE_MORE_THAN_MAX;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.String.HREF_LENGTH_WITHOUT_TEMPLATE_MARKER_CANNOT_BE_MORE_THAN_MAX;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.String.INVALID_SPEC_SYMBOL;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.String.LENGTH_WORD_WITHOUT_TEMPLATE_MARKER_CANNOT_BE_MORE_THAN_MAX;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.String.MAX_NUMBER_OF_NARROW_CHARACTERS_CANNOT_BE_MORE_THAN_MAX;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.String.NO_RIGHTS_TO_AUDIENCE_PIXEL;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.String.RESTRICTED_CHARS_IN_DISPLAY_HREF;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.String.SHOULD_NOT_BE_BLANK;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.String.TEXT_LENGTH_WITHOUT_TEMPLATE_MARKER_CANNOT_BE_MORE_THAN_MAX;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.intapiDefect;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.paramIntapiDefect;

public class BannerDefectPresentations {

    private BannerDefectPresentations() {
    }

    @SuppressWarnings("checkstyle:methodlength")
    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> bannerDefectPresentationRegistry() {
        BannerDefectTranslations translations = BannerDefectTranslations.INSTANCE;
        CommonDefectTranslations commonTranslations = CommonDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(ILLEGAL_COMMA,
                        defaultIntapiDefect())
                .register(SITELINK_DOMAIN_IS_NOT_FIT_TO_BANNER,
                        defaultIntapiDefect())
                .register(INSUFFICIENT_RIGHTS,
                        defaultIntapiDefect())
                .register(INVALID_HREF,
                        defaultIntapiDefect())
                .register(INVALID_DOMAIN,
                        defaultIntapiDefect())
                .register(INVALID_TEMPLATE_QUERY,
                        defaultIntapiDefect())
                .register(CANNOT_HAVE_TEMPLATE,
                        defaultIntapiDefect())
                .register(INVALID_DISPLAY_HREF_USAGE,
                        defaultIntapiDefect())
                .register(INVALID_SITELINK_SET_USAGE,
                        defaultIntapiDefect())
                .register(REQUIRED_HREF_OR_VCARD_ID,
                        defaultIntapiDefect())
                .register(REQUIRED_HREF_OR_TURBOLANDING_ID,
                        defaultIntapiDefect())
                .register(REQUIRED_IMAGE_HASH_OR_CREATIVE_ID,
                        defaultIntapiDefect())
                .register(REQUIRED_ONLY_IMAGE_OR_CREATIVE_ID,
                        defaultIntapiDefect())
                .register(CANNOT_CHANGE_IMAGE_TO_CREATIVE_ID,
                        defaultIntapiDefect())
                .register(CANNOT_CHANGE_CREATIVE_ID_TO_IMAGE,
                        defaultIntapiDefect())
                .register(BANNER_HREF_IS_INCOMPATIBLE_WITH_PAY_FOR_CONVERSION_STRATEGY,
                        defaultIntapiDefect())
                .register(BANNER_SITELINKS_HREF_IS_INCOMPATIBLE_WITH_PAY_FOR_CONVERSION_STRATEGY,
                        defaultIntapiDefect())
                .register(INCONSISTENT_STATE_BANNER_TYPE_AND_ADGROUP_TYPE,
                        defaultIntapiDefect())
                .register(INCONSISTENT_STATE_BANNER_TYPE_AND_IMAGE_TYPE,
                        defaultIntapiDefect())
                .register(INCONSISTENT_STATE_BANNER_TYPE_AND_TURBOLANDING_TYPE,
                        defaultIntapiDefect())
                .register(ARCHIVED_BANNER_MODIFICATION,
                        defaultIntapiDefect())
                .register(UNSUPPORTED_BANNER_TYPE,
                        defaultIntapiDefect())
                .register(UNSUPPORTED_BUTTON_ACTION,
                        defaultIntapiDefect())
                .register(CLIENT_HAS_NOT_CREATIVES,
                        defaultIntapiDefect())
                .register(REQUIRED_VIDEO_ADDITION_TYPE_ONLY,
                        defaultIntapiDefect())
                .register(REQUIRED_CPM_VIDEO_TYPE_ONLY,
                        defaultIntapiDefect())
                .register(INCONSISTENT_CREATIVE_AND_CPM_VIDEO_AD_GROUP_SKIPPABILITY,
                        defaultIntapiDefect())
                .register(REQUIRED_CPM_AUDIO_TYPE_ONLY,
                        defaultIntapiDefect())
                .register(REQUIRED_HTML5_TYPE_ONLY,
                        defaultIntapiDefect())
                .register(REQUIRED_CANVAS_OR_HTML5_TYPES,
                        defaultIntapiDefect())
                .register(REQUIRED_CANVAS_TYPE_ONLY,
                        defaultIntapiDefect())
                .register(INCONSISTENT_CREATIVE_TYPE_TO_BANNER_TYPE,
                        defaultIntapiDefect())
                .register(INCONSISTENT_CREATIVE_BUSINESS_TYPE_TO_FEED_BUSINESS_TYPE,
                        defaultIntapiDefect())
                .register(INCONSISTENT_CREATIVE_GEO_TO_ADGROUP_GEO,
                        defaultIntapiDefect())
                .register(INCONSISTENT_CREATIVE_FORMAT,
                        defaultIntapiDefect())
                .register(BANNER_MODERATE_WITH_EMPTY_GROUP,
                        defaultIntapiDefect())
                .register(FORBIDDEN_MOBILE_BANNER,
                        defaultIntapiDefect())
                .register(ACTION_IN_ARCHIVED_CAMPAIGN,
                        defaultIntapiDefect())
                .register(HREF_LENGTH_WITHOUT_TEMPLATE_MARKER_CANNOT_BE_MORE_THAN_MAX,
                        defaultIntapiDefect())
                .register(LENGTH_WORD_WITHOUT_TEMPLATE_MARKER_CANNOT_BE_MORE_THAN_MAX,
                        defaultIntapiDefect())
                .register(MAX_BANNERS_IN_ADGROUP,
                        defaultIntapiDefect())
                .register(MAX_BANNERS_IN_INTERNAL_CAMPAIGN,
                        defaultIntapiDefect())
                .register(MAX_BANNERS_IN_UNIVERSAL_APP_CAMPAIGN,
                        defaultIntapiDefect())
                .register(INCONSISTENT_LANGUAGE_WITH_GEO,
                        defaultIntapiDefect())
                .register(MAX_NUMBER_OF_NARROW_CHARACTERS_CANNOT_BE_MORE_THAN_MAX,
                        defaultIntapiDefect())
                .register(INCONSISTENT_BANNER_TYPE,
                        defaultIntapiDefect())
                .register(BANNER_TYPE_MODIFICATION,
                        defaultIntapiDefect())
                .register(IMAGE_NOT_FOUND,
                        intapiDefect(translations.imageNotFoundDetailed()))
                .register(EMPTY_HREF,
                        intapiDefect(translations.emptyHrefDetailed()))
                .register(THIS_TRACKING_SYSTEM_DOMAIN_NOT_SUPPORTED,
                        intapiDefect(translations.trackingSystemDomainNotSupported()))
                .register(INCONSISTENT_BANNER_CID_AND_CAMPAIGN_ID,
                        defaultIntapiDefect())
                .register(AD_GROUP_NOT_FOUND,
                        intapiDefect(translations.adGroupNotFoundDetailed()))
                .register(ADD_TO_ARCHIVED_CAMPAIGN_NOT_ALLOWED,
                        intapiDefect(translations.addToArchivedCampaignNotAllowedDetailed()))
                .register(SITELINKS_SET_NOT_FOUND,
                        intapiDefect(translations.sitelinksSetNotFoundDetailed()))
                .register(TURBO_PAGE_NOT_FOUND,
                        intapiDefect(translations.turboPageNotFoundDetailed()))
                .register(VCARD_NOT_FOUND,
                        intapiDefect(translations.vcardNotFoundDetailed()))
                .register(AD_EXTENSION_NOT_FOUND,
                        paramIntapiDefect(di -> translations.adExtensionNotFoundDetailed(modelIdIdentity(di))))
                .register(AD_GROUP_TYPE_NOT_SUPPORTED,
                        intapiDefect(commonTranslations.adGroupTypeNotSupportedDetailed()))
                .register(AD_MORE_THAN_ONCE_IN_REQUEST,
                        intapiDefect(translations.adMoreThanOnceInRequest()))
                .register(ARRAY_ELEMENT_INVALID_ID,
                        paramIntapiDefect(di -> translations.invalidIdInArrayElement(di.getPath())))
                .register(DUPLICATE_SPECIAL_CHARS_IN_DISPLAY_HREF,
                        intapiDefect(translations.duplicateSpecCharsInDisplayHrefDetailed()))
                .register(EMPTY_DISPLAY_HREF,
                        paramIntapiDefect(di -> commonTranslations.emptyDetailed(di.getPath())))
                .register(EMPTY_VALUE,
                        paramIntapiDefect(di -> translations.emptyValueInField(di.getPath())))
                .register(RESTRICTED_CHARS_IN_FIELD,
                        paramIntapiDefect(di -> commonTranslations.invalidCharsDetailed(di.getPath())))
                .register(VCARD_OF_ANOTHER_CAMPAIGN,
                        intapiDefect(translations.vcardOfAnotherCampaignDetailed()))
                .register(VIDEO_EXTENSION_NOT_FOUND,
                        intapiDefect(translations.videoExtNotFoundDetailed()))
                .register(CPC_VIDEO_NOT_FOUND,
                        intapiDefect(translations.cpcVideoNotFoundDetailed()))
                .register(DUPLICATED_AD_EXTENSION_ID,
                        paramIntapiDefect(di -> translations.duplicatedAdExtensionIdDetailed(modelIdIdentity(di))))
                .register(MAX_CALLOUTS_ON_BANNER_ADD,
                        paramIntapiDefect(di -> translations.adExtensionsLimitExceededDetailed(
                                new Identity(di.getDefect().params().getMaxSize()))))
                .register(MAX_CALLOUTS_PER_BANNER,
                        paramIntapiDefect(di -> translations.adExtensionsPerBannerLimitExceededDetailed(
                                new Identity(di.getDefect().params().getMaxSize()))))
                .register(MAX_YA_AUD_PIXELS_ON_BANNER,
                        intapiDefect(translations.maxYaAudiencePixelsOnBannerExceeded()))
                .register(MAX_FOREIGN_PIXELS_ON_BANNER,
                        intapiDefect(translations.maxNonYaAudiencePixelsOnBannerExceeded()))
                .register(DISPLAY_HREF_LENGTH_CANNOT_BE_MORE_THAN_MAX,
                        defaultIntapiDefect())
                .register(RESTRICTED_CHARS_IN_DISPLAY_HREF,
                        defaultIntapiDefect())
                .register(SHOULD_NOT_BE_BLANK,
                        defaultIntapiDefect())
                .register(TEXT_LENGTH_WITHOUT_TEMPLATE_MARKER_CANNOT_BE_MORE_THAN_MAX,
                        defaultIntapiDefect())
                .register(THIS_TRACKING_SYSTEM_DOMAIN_ONLY_SUPPORTS_HTTPS,
                        intapiDefect(translations.trackingSystemDomainSupportsHttpsOnly()))
                .register(CREATIVE_NOT_FOUND,
                        intapiDefect(translations.creativeNotFound()))
                .register(CANNOT_UPDATE_ARCHIVED_AD,
                        intapiDefect(translations.cannotUpdateArchivedAd()))
                .register(AD_NOT_FOUND,
                        intapiDefect(translations.adNotFoundDetailed()))
                .register(IMAGE_SIZE_MODIFICATION,
                        intapiDefect(translations.cannotUpdateImageSize()))
                .register(IMAGE_SIZE_NOT_FOUND,
                        defaultIntapiDefect())
                .register(IMAGE_SIZE_INVALID,
                        defaultIntapiDefect())
                .register(SUSPEND_IN_ARCHIVED_CAMPAIGN,
                        paramIntapiDefect(di -> translations.suspendBannerInArchivedCampaign(
                                new Identity(di.getDefect().params().getId()))))
                .register(RESUME_IN_ARCHIVED_CAMPAIGN,
                        paramIntapiDefect(di -> translations.resumeBannerInArchivedCampaign(
                                new Identity(di.getDefect().params().getId()))))
                .register(SUSPEND_ARCHIVED_BANNER,
                        intapiDefect(translations.cannotSuspendArchivedBanner()))
                .register(RESUME_ARCHIVED_BANNER,
                        intapiDefect(translations.cannotResumeArchivedBanner()))
                .register(SUSPEND_DRAFT_BANNER,
                        intapiDefect(translations.cannotSuspendDraftBanner()))
                .register(RESUME_DRAFT_BANNER,
                        intapiDefect(translations.cannotResumeDraftBanner()))
                .register(ALREADY_SUSPENDED,
                        intapiDefect(translations.alreadySuspended()))
                .register(IS_NOT_SUSPENDED,
                        intapiDefect(translations.isNotSuspended()))
                .register(ALREADY_ARCHIVED,
                        intapiDefect(translations.alreadyArchived()))
                .register(IS_NOT_ARCHIVED,
                        intapiDefect(translations.isNotArchived()))
                .register(ARCHIVE_BANNER_SHOWN_IN_BS,
                        intapiDefect(translations.cannotArchiveBannerShownInBs()))
                .register(ARCHIVE_DRAFT_BANNER,
                        intapiDefect(translations.cannotArchiveDraftBanner()))
                .register(INVALID_PIXEL_FORMAT,
                        intapiDefect(translations.invalidPixelFormat()))
                .register(ARCHIVE_IN_ARCHIVED_CAMPAIGN,
                        paramIntapiDefect(di -> translations.archiveInArchivedCampaign(
                                new Identity(di.getDefect().params().getId()))))
                .register(UNARCHIVE_IN_ARCHIVED_CAMPAIGN,
                        paramIntapiDefect(di -> translations.unarchiveInArchivedCampaign(
                                new Identity(di.getDefect().params().getId()))))
                .register(CANNOT_CHANGE_BANNER_FLAGS_FROM_BABY_FOOD_TO_OTHER_TYPES,
                        defaultIntapiDefect())
                .register(CANNOT_CHANGE_BANNER_FLAGS_FROM_AGE_TO_OTHER_TYPES,
                        defaultIntapiDefect())
                .register(CLIENT_CANNOT_SET_BANNER_FLAGS,
                        defaultIntapiDefect())
                .register(UNABLE_TO_DELETE,
                        intapiDefect(translations.unableToDeleteDetailed()))
                .register(TRACKING_URL_DOESNT_CONTAIN_MACROS,
                        intapiDefect(translations.trackingUrlDoesntContainMacros()))
                .register(NO_RIGHTS_TO_PIXEL,
                        paramIntapiDefect(di -> translations.noRightsToPixel(
                                di.getDefect().params().getPixelUrl())))
                .register(EQUAL_PIXEL_PROVIDERS,
                        paramIntapiDefect(di -> translations.equalPixelProviders(
                                di.getDefect().params().getExceededClientPixelProviderNamesJoined())))
                .register(NO_RIGHTS_TO_AUDIENCE_PIXEL,
                        paramIntapiDefect(di -> translations.noRightsToAudiencePixel(
                                di.getDefect().params().getAllInvalidSubstrings())))
                .register(INVALID_SPEC_SYMBOL, defaultIntapiDefect())
                .register(INVALID_PIXEL_WITH_MEASURER, paramIntapiDefect(di -> translations.invalidPixelWithMeasurer(
                        di.getDefect().params().getPixelUrl(), di.getDefect().params().getMeasurerSystemName())))
                .register(MODERATE_BANNER_IN_GROUP_WITHOUT_SHOW_CONDITIONS,
                        intapiDefect(translations.moderateBannerInAdGroupWithoutShowConditions()))
                .register(MODERATE_ARCHIVED_BANNER,
                        intapiDefect(translations.moderateArchivedBanner()))
                .register(MODERATE_NON_DRAFT_BANNER,
                        intapiDefect(translations.moderateNonDraftBanner()))
                .register(REMODERATE_DRAFT_BANNER,
                        intapiDefect(translations.remoderateDraftBanner()))
                .register(MODERATE_BANNER_IN_ARCHIVED_CAMPAIGN,
                        paramIntapiDefect(di -> translations.moderateBannerInArchivedCampaign(
                                new Identity(di.getDefect().params().getId()))))
                .register(CANNOT_HAVE_TURBOLANDINGS, defaultIntapiDefect())
                .register(CONTENT_TYPE_NOT_MATCHES_ADGROUP_CONTENT_TYPE, defaultIntapiDefect())
                .register(CONTENT_PROMOTION_VIDEO_IS_INACCESSIBLE,
                        intapiDefect(translations.contentPromotionVideoIsInaccessible()))
                .register(CONTENT_PROMOTION_COLLECTION_IS_INACCESSIBLE,
                        intapiDefect(translations.contentPromotionCollectionIsInaccessible()))
                .register(FORBIDDEN_TO_CHANGE, defaultIntapiDefect())
                .register(INTERNAL_TEMPLATE_NOT_ALLOWED, defaultIntapiDefect())
                .register(INTERNAL_TEMPLATE_VARIABLES_MISMATCH, defaultIntapiDefect())
                .register(REQUIRED_CAMPAIGNS_IMPRESSION_RATE_BUT_EMPTY, defaultIntapiDefect())
                .register(REQUIRED_AD_GROUPS_IMPRESSION_RATE_BUT_EMPTY, defaultIntapiDefect())
                .register(REQUIRED_CAMPAIGN_OR_AD_GROUP_MAX_STOPS_COUNT_BUT_EMPTY, defaultIntapiDefect())
                .register(BANNER_PRICE_MISSING, defaultIntapiDefect())
                .register(BANNER_PRICE_CURRENCY_MISSING, defaultIntapiDefect())
                .register(BANNER_PRICE_GREATER_THAN_OLD, defaultIntapiDefect())
                .register(BANNER_CANNOT_HAVE_TURBO_GALLERY_HREF, defaultIntapiDefect())
                .register(MUST_BE_GREATER_THAN_MIN, defaultIntapiDefect())
                .register(MUST_BE_LESS_THEN_OR_EQUAL_TO_MAX, defaultIntapiDefect())
                .register(PRICE_SALES_FULLNESS_VIOLATED, defaultIntapiDefect())
                .register(PRICE_SALES_CAMPAIGN_GEO_OVERLAPS_BANNER_MINUS_GEO, defaultIntapiDefect())
                .register(PRICE_SALES_DISALLOWED_CREATIVE_TEMPLATE, defaultIntapiDefect())
                .register(ERRORS_WHILE_COPYING_BANNERS, defaultIntapiDefect())
                .register(REMODERATE_BANNER_IN_DRAFT_CAMPAIGN,
                        paramIntapiDefect(di -> translations.remoderateBannerInDraftCampaign(
                                new Identity(di.getDefect().params().getId()))))
                .register(REMODERATE_BANNER_IS_NOT_ALLOWED, intapiDefect(translations.remoderateBannerIsNotAllowed()))
                .register(REMODERATE_BANNER_WITH_NOT_ALLOWED_MOD_REASONS,
                        intapiDefect(translations.remoderateBannerWithNotAllowedModReasons()))
                .register(REMODERATE_BANNER_WITH_NO_MOD_REASONS,
                        intapiDefect(translations.remoderateBannerWithNoModReasons()))
                .register(INCONSISTENT_LEADFORM_HREF_AND_BUTTON_TEXT, defaultIntapiDefect())
                .register(DIFFERENT_TEMPLATES_NOT_ALLOWED, defaultIntapiDefect())
                .register(TEMPLATE_RESOURCE_ID_NOT_FOUND, defaultIntapiDefect())
                .register(TEMPLATE_MUST_BE_MODERATED, defaultIntapiDefect())
                .register(INCORRECT_IMPRESSION_URL_TRACKING_SYSTEM,
                        intapiDefect(translations.incorrectImpressionUrlTrackingSystem()))
                .register(INCORRECT_IMPRESSION_URL_TRACKER_ID,
                        intapiDefect(translations.incorrectImpressionUrlTrackerId()))
                .build();
    }

    private static Identity modelIdIdentity(DefectInfo<? extends Defect<ModelIdDefectParams>> defect) {
        return new Identity(defect.getDefect().params().getId());
    }
}
