package ru.yandex.direct.intapi.entity.bid.presentation;

import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;

import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Bids.BAD_STATUS_CAMPAIGN_ARCHIVED_ON_UPDATE_BIDS;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Bids.FIELD_DOES_NOT_MATCH_STRATEGY;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Bids.FIELD_REQUIRED_FOR_CONTEXT_STRATEGY;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Bids.FIELD_REQUIRED_FOR_SEARCH_STRATEGY;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Bids.NOT_FOUND_SHOW_CONDITION_BY_PARAMETERS;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Bids.RELEVANCE_MATCH_CANT_BE_USED_IN_SET_AUTO;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.BidsDefects2Fields.DEPENDENT_FIELD_MISSING;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.CurrencyAmountDefects.CPM_PRICE_IS_NOT_GREATER_THAN_MIN;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.CurrencyAmountDefects.CPM_PRICE_IS_NOT_SMALLER_THAN_MAX;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.CurrencyAmountDefects.SEARCH_PRICE_IS_NOT_GREATER_THAN_MIN;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.CurrencyAmountDefects.SEARCH_PRICE_IS_NOT_SMALLER_THAN_MAX;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.BID_FOR_CONTEXT_NOT_ALLOWED_NET_IS_SWITCHED_OFF;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.BID_FOR_CONTEXT_NOT_ALLOWED_NOT_DIFFERENT_PLACES;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.BID_FOR_CONTEXT_WONT_BE_ACCEPTED_IN_CASE_OF_AUTOBUDGET_STRATEGY;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.BID_FOR_CONTEXT_WONT_BE_ACCEPTED_NET_IS_SWITCHED_OFF;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.BID_FOR_CONTEXT_WONT_BE_ACCEPTED_NOT_DIFFERENT_PLACES;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.BID_FOR_SEARCH_NOT_ALLOWED_SEARCH_IS_SWITCHED_OFF;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.BID_FOR_SEARCH_WONT_BE_ACCEPTED_IN_CASE_OF_AUTOBUDGET_STRATEGY;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.BID_FOR_SEARCH_WONT_BE_ACCEPTED_SEARCH_IS_SWITCHED_OFF;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.BID_NOT_ALLOWED_FOR_AUTOBUDGET_STRATEGY;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.BID_NOT_ALLOWED_FOR_BS_RARELY_LOADED_ADGROUP;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.CONTEXT_PRICE_IS_NOT_SET_FOR_MANUAL_STRATEGY;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.MIXED_TYPES;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.PRIORITY_HAS_WRONG_VALUE;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.PRIORITY_IS_NOT_SET_FOR_AUTO_STRATEGY;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.PRIORITY_WONT_BE_ACCEPTED_IN_CASE_OF_NOT_AUTO_BUDGET_STRATEGY;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.SEARCH_PRICE_IS_NOT_SET_FOR_MANUAL_STRATEGY;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.Ids.STRATEGY_IS_NOT_SET;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.ModelDefects.ONE_OF_FIELDS_SHOULD_BE_SPECIFIED;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.ModelDefects.POSSIBLE_ONLY_ONE_FIELD;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.ModelDefects.REQUIRED_AT_LEAST_ONE_OF_FIELDS;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.ModelDefects.REQUIRED_AT_LEAST_ONE_OF_FIELDS_FOR_AUTOBUDGET_STRATEGY;
import static ru.yandex.direct.core.entity.bids.validation.BidsDefects.ModelDefects.REQUIRED_AT_LEAST_ONE_OF_FIELDS_FOR_MANUAL_STRATEGY;
import static ru.yandex.direct.currency.CurrencyAmount.fromMoney;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.paramIntapiDefect;

public class BidDefectPresentations {

    private BidDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> bidDefectPresentationRegistry() {
        CommonDefectTranslations translations = CommonDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(BAD_STATUS_CAMPAIGN_ARCHIVED_ON_UPDATE_BIDS,
                        defaultIntapiDefect())
                .register(NOT_FOUND_SHOW_CONDITION_BY_PARAMETERS,
                        defaultIntapiDefect())
                .register(FIELD_DOES_NOT_MATCH_STRATEGY,
                        defaultIntapiDefect())
                .register(FIELD_REQUIRED_FOR_SEARCH_STRATEGY,
                        defaultIntapiDefect())
                .register(FIELD_REQUIRED_FOR_CONTEXT_STRATEGY,
                        defaultIntapiDefect())
                .register(RELEVANCE_MATCH_CANT_BE_USED_IN_SET_AUTO,
                        defaultIntapiDefect())
                .register(DEPENDENT_FIELD_MISSING,
                        defaultIntapiDefect())
                .register(SEARCH_PRICE_IS_NOT_GREATER_THAN_MIN,
                        paramIntapiDefect(di -> translations.notLessThan(
                                di.getPath(),
                                fromMoney(di.getDefect().params().getMoneyValue()))))
                .register(SEARCH_PRICE_IS_NOT_SMALLER_THAN_MAX,
                        paramIntapiDefect(di -> translations.notGreaterThan(
                                di.getPath(),
                                fromMoney(di.getDefect().params().getMoneyValue()))))
                .register(CPM_PRICE_IS_NOT_GREATER_THAN_MIN,
                        paramIntapiDefect(di -> translations.notLessThan(
                                di.getPath(),
                                fromMoney(di.getDefect().params().getMoneyValue()))))
                .register(CPM_PRICE_IS_NOT_SMALLER_THAN_MAX,
                        paramIntapiDefect(di -> translations.notGreaterThan(
                                di.getPath(),
                                fromMoney(di.getDefect().params().getMoneyValue()))))
                .register(REQUIRED_AT_LEAST_ONE_OF_FIELDS,
                        defaultIntapiDefect())
                .register(POSSIBLE_ONLY_ONE_FIELD,
                        defaultIntapiDefect())
                .register(ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                        defaultIntapiDefect())
                .register(MIXED_TYPES,
                        defaultIntapiDefect())
                .register(STRATEGY_IS_NOT_SET,
                        defaultIntapiDefect())
                .register(SEARCH_PRICE_IS_NOT_SET_FOR_MANUAL_STRATEGY,
                        defaultIntapiDefect())
                .register(CONTEXT_PRICE_IS_NOT_SET_FOR_MANUAL_STRATEGY,
                        paramIntapiDefect(di -> translations.requiredButEmptyDetailed(di.getPath())))
                .register(PRIORITY_IS_NOT_SET_FOR_AUTO_STRATEGY,
                        paramIntapiDefect(di -> translations.requiredButEmptyDetailed(di.getPath())))
                .register(BID_FOR_SEARCH_WONT_BE_ACCEPTED_IN_CASE_OF_AUTOBUDGET_STRATEGY,
                        defaultIntapiDefect())
                .register(PRIORITY_WONT_BE_ACCEPTED_IN_CASE_OF_NOT_AUTO_BUDGET_STRATEGY,
                        defaultIntapiDefect())
                .register(PRIORITY_HAS_WRONG_VALUE,
                        defaultIntapiDefect())
                .register(REQUIRED_AT_LEAST_ONE_OF_FIELDS_FOR_MANUAL_STRATEGY,
                        defaultIntapiDefect())
                .register(REQUIRED_AT_LEAST_ONE_OF_FIELDS_FOR_AUTOBUDGET_STRATEGY,
                        defaultIntapiDefect())
                .register(BID_FOR_CONTEXT_WONT_BE_ACCEPTED_IN_CASE_OF_AUTOBUDGET_STRATEGY,
                        defaultIntapiDefect())
                .register(BID_NOT_ALLOWED_FOR_AUTOBUDGET_STRATEGY,
                        defaultIntapiDefect())
                .register(BID_NOT_ALLOWED_FOR_BS_RARELY_LOADED_ADGROUP,
                        defaultIntapiDefect())
                .register(BID_FOR_SEARCH_NOT_ALLOWED_SEARCH_IS_SWITCHED_OFF,
                        defaultIntapiDefect())
                .register(BID_FOR_CONTEXT_NOT_ALLOWED_NET_IS_SWITCHED_OFF,
                        defaultIntapiDefect())
                .register(BID_FOR_CONTEXT_NOT_ALLOWED_NOT_DIFFERENT_PLACES,
                        defaultIntapiDefect())
                .register(BID_FOR_SEARCH_WONT_BE_ACCEPTED_SEARCH_IS_SWITCHED_OFF,
                        defaultIntapiDefect())
                .register(BID_FOR_CONTEXT_WONT_BE_ACCEPTED_NET_IS_SWITCHED_OFF,
                        defaultIntapiDefect())
                .register(BID_FOR_CONTEXT_WONT_BE_ACCEPTED_NOT_DIFFERENT_PLACES,
                        defaultIntapiDefect())
                .build();
    }
}
