package ru.yandex.direct.intapi.entity.bidmodifiers.presentation;

import ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectTranslations;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;

import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.AB_SEGMENT_BID_MODIFIERS_INTERSECTION;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.AB_SEGMENT_BID_MODIFIERS_NOT_SUPPORTED_ON_ADGROUPS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.ADJUSTMENT_NOT_FOUND;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.ADJUSTMENT_SET_NOT_FOUND;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.CONFLICT_APPLYING_CHANGES;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.DEMOGRAPHICS_CONDITIONS_INTERSECTION;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.DEVICE_BID_MODIFIERS_ALL_ZEROS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.DUPLICATE_ADJUSTMENT;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.DUPLICATE_RETARGETING_CONDITION;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.DUPLICATE_SINGLE_ADJUSTMENT;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.EXPRESSION_ADJUSTMENT_IS_CONSTANT_FOR_ANY_VALUES;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.EXPRESSION_CONDITIONS_INTERSECTION;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.GEO_BID_MODIFIERS_NOT_SUPPORTED_ON_ADGROUPS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.GEO_REGIONS_INTERSECTION;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.INVALID_EXPRESSION_LITERAL;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.INVALID_PARAMETER;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.INVALID_PARAMETER_VALUE;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.INVALID_PERCENT_SHOULD_BE_POSITIVE;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.NOT_SUPPORTED_MULTIPLIER;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.ONE_TYPE_USED_TWICE_IN_COMPLEX_MODIFIER;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.REQUIRED_AT_LEAST_ONE_EXPRESSION;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.REQUIRED_AT_LEAST_ONE_OF_AGE_OR_GENDER;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.REQUIRED_EXPRESSION_FIELDS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.SETTING_OS_TYPE_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.SINGLE_VALUE_MODIFIER_ALREADY_EXISTS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.TRAFARET_POSITIONS_INTERSECTION;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.GeneralDefects.UNSUPPORTED_RETARGETING_TYPE;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.IdParametrized.AB_SEGMENT_NOT_FOUND;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.IdParametrized.AB_SEGMENT_SECTION_NOT_FOUND;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.IntegerDefects.TEMP_MUST_BE_GREATER_OR_EQUAL;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.IntegerDefects.TEMP_MUST_BE_LESS_OR_EQUAL;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.LimitOffsetDefects.BID_MODIFIERS_ADD_ITEMS_LIMIT_EXCEEDED;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.LimitOffsetDefects.BID_MODIFIERS_GET_HARD_LIMIT_EXCEEDED;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.LimitOffsetDefects.BID_MODIFIERS_SET_ITEMS_LIMIT_EXCEEDED;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.LimitOffsetDefects.BID_MODIFIERS_TOGGLE_ITEMS_LIMIT_EXCEEDED;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.ModelDefects.POSSIBLE_ONLY_ONE_FIELD;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.ModelDefects.REQUIRED_AT_LEAST_ONE_OF_FIELDS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.Number.TOO_MANY_DEMOGRAPHY_CONDITIONS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.Number.TOO_MANY_EXPRESSION_CONDITIONS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.Number.TOO_MANY_INVENTORY_CONDITIONS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.Number.TOO_MANY_RETARGETING_CONDITIONS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.Number.TOO_MANY_TRAFARET_POSITION_CONDITIONS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.Number.TOO_MANY_WEATHER_CONDITIONS;
import static ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds.RegionIdsDefects.NONEXISTENT_REGION_IDS;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.paramIntapiDefect;

public class BidModifierDefectPresentations {

    private BidModifierDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> bidModifierDefectPresentationRegistry() {
        BidModifiersDefectTranslations bidModifierTranslations = BidModifiersDefectTranslations.INSTANCE;
        CommonDefectTranslations commonDefectTranslations = CommonDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(TOO_MANY_DEMOGRAPHY_CONDITIONS,
                        paramIntapiDefect(di -> bidModifierTranslations
                                .tooManyDemographyConditions(idty(di.getDefect().params().getMax()))))
                .register(TOO_MANY_RETARGETING_CONDITIONS,
                        paramIntapiDefect(di -> bidModifierTranslations
                                .tooManyRetargetingConditions(idty(di.getDefect().params().getMax()))))
                .register(TOO_MANY_WEATHER_CONDITIONS,
                        paramIntapiDefect(di -> bidModifierTranslations
                                .tooManyWeatherConditions(idty(di.getDefect().params().getMax()))))
                .register(TOO_MANY_EXPRESSION_CONDITIONS,
                        paramIntapiDefect(di -> bidModifierTranslations
                                .tooManyExpressionConditions(idty(di.getDefect().params().getMax()))))
                .register(TOO_MANY_INVENTORY_CONDITIONS,
                        defaultIntapiDefect())
                .register(TOO_MANY_TRAFARET_POSITION_CONDITIONS,
                        paramIntapiDefect(di -> bidModifierTranslations
                                .tooManyTrafaretPositionConditions(idty(di.getDefect().params().getMax()))))
                .register(REQUIRED_AT_LEAST_ONE_OF_FIELDS,
                        paramIntapiDefect(di -> commonDefectTranslations.requiredAtLeastOneOfFieldsShort()))
                .register(POSSIBLE_ONLY_ONE_FIELD,
                        paramIntapiDefect(di -> commonDefectTranslations.possibleOnlyOneFieldShort()))
                .register(BID_MODIFIERS_GET_HARD_LIMIT_EXCEEDED,
                        paramIntapiDefect(di -> commonDefectTranslations
                                .tooBroadSelectionClauseDetailed(idty(di.getDefect().params()))))
                .register(BID_MODIFIERS_ADD_ITEMS_LIMIT_EXCEEDED,
                        paramIntapiDefect(
                                di -> bidModifierTranslations.addItemsLimitExceeded(idty(di.getDefect().params()))))
                .register(BID_MODIFIERS_TOGGLE_ITEMS_LIMIT_EXCEEDED,
                        paramIntapiDefect(
                                di -> bidModifierTranslations.toggleItemsLimitExceeded(idty(di.getDefect().params()))))
                .register(GEO_BID_MODIFIERS_NOT_SUPPORTED_ON_ADGROUPS,
                        paramIntapiDefect(
                                di -> bidModifierTranslations.geoBidModifiersNotSupportedOnAdGroupsDetailed()))
                .register(DUPLICATE_RETARGETING_CONDITION,
                        paramIntapiDefect(di -> bidModifierTranslations.duplicateRetargetingConditionDetailed()))
                .register(DUPLICATE_ADJUSTMENT,
                        paramIntapiDefect(di -> bidModifierTranslations.duplicateAdjustmentDetailed()))
                .register(DUPLICATE_SINGLE_ADJUSTMENT,
                        paramIntapiDefect(di -> bidModifierTranslations.duplicateSingleAdjustmentDetailed()))
                .register(REQUIRED_AT_LEAST_ONE_OF_AGE_OR_GENDER,
                        paramIntapiDefect(di -> bidModifierTranslations.requiredAtLeastOneOfAgeOrGender()))
                .register(REQUIRED_AT_LEAST_ONE_EXPRESSION,
                        paramIntapiDefect(di -> bidModifierTranslations.requiredAtLeastOneExpression()))
                .register(REQUIRED_EXPRESSION_FIELDS,
                        paramIntapiDefect(di -> bidModifierTranslations.requiredExpressionFields()))
                .register(INVALID_PARAMETER_VALUE,
                        paramIntapiDefect(di -> bidModifierTranslations.invalidParameterValue()))
                .register(INVALID_PARAMETER,
                        paramIntapiDefect(di -> bidModifierTranslations.invalidParameter()))
                .register(TEMP_MUST_BE_GREATER_OR_EQUAL,
                        paramIntapiDefect(di -> bidModifierTranslations
                                .tempMustBeGreaterThanOrEqualToMin(di.getDefect().params())))
                .register(TEMP_MUST_BE_LESS_OR_EQUAL,
                        paramIntapiDefect(
                                di -> bidModifierTranslations.tempMustBeLessThanOrEqualToMax(di.getDefect().params())))
                .register(DEMOGRAPHICS_CONDITIONS_INTERSECTION,
                        paramIntapiDefect(di -> bidModifierTranslations.demographicsConditionsIntersection()))
                .register(INVALID_PERCENT_SHOULD_BE_POSITIVE,
                        paramIntapiDefect(di -> bidModifierTranslations.invalidPercentNotPositive()))
                .register(NOT_SUPPORTED_MULTIPLIER,
                        paramIntapiDefect(di -> bidModifierTranslations.notSupportedMultiplier()))
                .register(GEO_REGIONS_INTERSECTION,
                        paramIntapiDefect(di -> bidModifierTranslations.geoRegionsIntersection()))
                .register(TRAFARET_POSITIONS_INTERSECTION,
                        paramIntapiDefect(di -> bidModifierTranslations.trafaretPositionsIntersection()))
                .register(SINGLE_VALUE_MODIFIER_ALREADY_EXISTS,
                        paramIntapiDefect(di -> commonDefectTranslations.alreadyExistsShort()))
                .register(CONFLICT_APPLYING_CHANGES,
                        paramIntapiDefect(di -> bidModifierTranslations.conflictApplyingChanges()))
                .register(BID_MODIFIERS_SET_ITEMS_LIMIT_EXCEEDED,
                        paramIntapiDefect(
                                di -> bidModifierTranslations.setItemsLimitExceeded(idty(di.getDefect().params()))))
                .register(ADJUSTMENT_NOT_FOUND,
                        paramIntapiDefect(di -> bidModifierTranslations.notFoundDetailed()))
                .register(ADJUSTMENT_SET_NOT_FOUND,
                        paramIntapiDefect(di -> bidModifierTranslations.setNotFoundDetailed()))
                .register(NONEXISTENT_REGION_IDS,
                        paramIntapiDefect(di -> bidModifierTranslations.nonexistentRegionIds(di.getDefect().params())))
                .register(AB_SEGMENT_BID_MODIFIERS_INTERSECTION,
                        paramIntapiDefect(di -> bidModifierTranslations.abSegmentsIntersection()))
                .register(AB_SEGMENT_NOT_FOUND,
                        paramIntapiDefect(
                                di -> bidModifierTranslations.abSegmentNotFound(idty(di.getDefect().params().getId()))))
                .register(AB_SEGMENT_SECTION_NOT_FOUND,
                        paramIntapiDefect(di -> bidModifierTranslations
                                .abSegmentSectionNotFound(idty(di.getDefect().params().getId()))))
                .register(AB_SEGMENT_BID_MODIFIERS_NOT_SUPPORTED_ON_ADGROUPS,
                        paramIntapiDefect(
                                di -> bidModifierTranslations.abSegmentBidModifiersNotSupportedOnAdGroupsDetailed()))
                .register(UNSUPPORTED_RETARGETING_TYPE,
                        paramIntapiDefect(di -> bidModifierTranslations.unsupportedRetargetingType()))
                .register(DEVICE_BID_MODIFIERS_ALL_ZEROS,
                        paramIntapiDefect(di -> bidModifierTranslations.deviceBidModifiersAllZeros()))
                .register(SETTING_OS_TYPE_NOT_ALLOWED,
                        paramIntapiDefect(di -> bidModifierTranslations.settingOsTypeNotAllowed()))
                .register(INVALID_EXPRESSION_LITERAL,
                        paramIntapiDefect(di -> bidModifierTranslations.invalidExpressionLiteral()))
                .register(EXPRESSION_ADJUSTMENT_IS_CONSTANT_FOR_ANY_VALUES,
                        paramIntapiDefect(di -> bidModifierTranslations.expressionAdjustmentIsConstantForAnyValues()))
                .register(EXPRESSION_CONDITIONS_INTERSECTION,
                        paramIntapiDefect(di -> bidModifierTranslations.expressionConditionsIntersection()))
                .register(ONE_TYPE_USED_TWICE_IN_COMPLEX_MODIFIER,
                        paramIntapiDefect(di -> bidModifierTranslations.oneTypeUsedTwiceInComplexModifier()))
                .build();
    }

    private static Identity idty(Number num) {
        return new Identity(num.longValue());
    }
}
