package ru.yandex.direct.intapi.entity.brandlift.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.direct.intapi.entity.brandlift.model.BrandliftStat;
import ru.yandex.direct.intapi.entity.brandlift.service.BrandliftService;
import ru.yandex.direct.intapi.logging.ClientIdParam;
import ru.yandex.direct.tvm.AllowServices;

import static ru.yandex.direct.tvm.TvmService.DIRECT_DEVELOPER;
import static ru.yandex.direct.tvm.TvmService.SURVEYS_PROD;
import static ru.yandex.direct.tvm.TvmService.SURVEYS_TEST;

@RestController
@Api(value = "API для получения статистики по кампаниям с брендлифтом")
@RequestMapping(path = "/brandlift")
@AllowServices(production = {SURVEYS_PROD, DIRECT_DEVELOPER}, testing = {SURVEYS_TEST, DIRECT_DEVELOPER})
public class BrandliftController {
    private final BrandliftService brandliftService;

    @Autowired
    public BrandliftController(
            BrandliftService brandliftService) {
        this.brandliftService = brandliftService;
    }

    @ApiOperation(value = "Статистика по кампаниям для презентации BL", httpMethod = "GET")
    @RequestMapping(path = "/stat", method = RequestMethod.GET)
    public BrandliftStat getStats(@RequestParam(value = "survey_id") String surveyId,
                                  @RequestParam(value = "client_id") @ClientIdParam Long clientId) {
        return brandliftService.getStats(surveyId, clientId);
    }
}
