package ru.yandex.direct.intapi.entity.bs.autobudget.restart;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.direct.autobudget.restart.model.CampStrategyRestartData;
import ru.yandex.direct.autobudget.restart.model.CampStrategyRestartResult;
import ru.yandex.direct.core.entity.campaign.service.CampaignAutobudgetRestartService;
import ru.yandex.direct.tvm.AllowServices;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON;
import static ru.yandex.direct.tvm.TvmService.DIRECT_AUTOTESTS;
import static ru.yandex.direct.tvm.TvmService.DIRECT_DEVELOPER;
import static ru.yandex.direct.tvm.TvmService.DIRECT_SCRIPTS_PROD;
import static ru.yandex.direct.tvm.TvmService.DIRECT_SCRIPTS_SANDBOX;
import static ru.yandex.direct.tvm.TvmService.DIRECT_SCRIPTS_SANDBOX_TEST;
import static ru.yandex.direct.tvm.TvmService.DIRECT_SCRIPTS_TEST;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@RestController
@RequestMapping("bs-autobudget-restart")
@Api(value = "Пересчёт рестарта автобюджета для БК")
@ParametersAreNonnullByDefault
public class AutobudgetRestartController {
    private final CampaignAutobudgetRestartService campaignAutobudgetRestartService;

    public AutobudgetRestartController(CampaignAutobudgetRestartService campaignAutobudgetRestartService) {
        this.campaignAutobudgetRestartService = campaignAutobudgetRestartService;
    }

    @AllowServices(
            sandboxTesting = {DIRECT_SCRIPTS_SANDBOX_TEST, DIRECT_DEVELOPER},
            testing = {DIRECT_SCRIPTS_TEST, DIRECT_AUTOTESTS, DIRECT_DEVELOPER},
            sandbox = {DIRECT_SCRIPTS_SANDBOX},
            production = {DIRECT_SCRIPTS_PROD}
    )
    @ApiOperation(value = "Пересчитать и получить время рестарта автобюджета для списка кампаний",
            httpMethod = "POST")
    @PostMapping(path = "calculate", consumes = APPLICATION_JSON)
    public List<CampStrategyRestartResult> calculate(
            @ApiParam(value = "campaigns", required = true)
            @RequestBody List<CampStrategyRestartData> campRestartData
    ) {
        return mapList(
                campaignAutobudgetRestartService.calculateRestartsAndSave(campRestartData),
                container -> container.getRestartResult()
        );
    }

}
