package ru.yandex.direct.intapi.entity.bs.export.utils;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import ru.yandex.direct.utils.HashingUtils;

public class FakeBsExportLogsUtils {

    public static final String ORDER = "ORDER";
    public static final String CONTEXT = "CONTEXT";
    public static final String BANNER = "BANNER";
    public static final String PRICE = "PRICE";

    private static final String PHRASE = "PHRASE";
    private static final String GOAL_CONTEXT = "GOAL_CONTEXT";
    private static final String DYNAMIC = "DYNAMIC";
    private static final String FILTER = "FILTER";
    private static final String RELEVANCE_MATCH = "RELEVANCE_MATCH";

    private static final String FIELD_ARCHIVE = "Archive";
    private static final String FIELD_STOP = "Stop";

    private static Map<String, List<String>> childMap = Map.of(
            "root", List.of(ORDER),
            ORDER, List.of(CONTEXT),
            CONTEXT, List.of(BANNER, PHRASE, GOAL_CONTEXT, DYNAMIC, FILTER, RELEVANCE_MATCH)
    );

    private FakeBsExportLogsUtils() {
    }

    /**
     * Рекурсивно заполняем ответ
     * <p>
     * ВНИМАНИЕ! Если меняете этот метод, то нужно также поменять аналогичный в перле - YaBSSOAPExport.pm
     *
     * @param level        - какой уровень ответа заполняем
     * @param requestNode  - запрос на уровне {@param level}
     * @param responseNode - ответ на уровне {@param level}
     */
    public static void fillResponse(String level, JsonNode requestNode, ObjectNode responseNode) {

        if (Set.of(ORDER, CONTEXT, BANNER, GOAL_CONTEXT, DYNAMIC, FILTER, PHRASE).contains(level)) {

            copyField(requestNode, responseNode, "EID");

            if (!requestNode.has("ID") || requestNode.get("ID").asText().equals("0")) {

                String idToSet;
                switch (level) {
                    case ORDER:
                    case CONTEXT:
                    case BANNER:
                        idToSet = requestNode.get("EID").asText();
                        break;
                    case GOAL_CONTEXT:
                    case DYNAMIC:
                    case FILTER:
                        idToSet = magicId(requestNode.get("EID").asText());
                        break;
                    case PHRASE:
                        if (requestNode.has("Text")) {
                            idToSet =
                                    HashingUtils.getYabsMd5HalfHashUtf8(requestNode.get("Text").asText()).toString();
                        } else {
                            idToSet = magicId(requestNode.get("EID").asText());
                        }
                        break;
                    default:
                        idToSet = "";
                        break;
                }
                responseNode.put("ID", idToSet);
            } else {
                copyField(requestNode, responseNode, "ID");
            }
        }

        if (ORDER.equals(level) && requestNode.has(FIELD_ARCHIVE)) {
            responseNode.put(FIELD_ARCHIVE, requestNode.get(FIELD_ARCHIVE).asText());
        }
        if (RELEVANCE_MATCH.equals(level)) {
            copyField(requestNode, responseNode, "EID");
        }
        if (Set.of(ORDER, BANNER).contains(level) && requestNode.has(FIELD_STOP)) {
            responseNode.put(FIELD_STOP, requestNode.get(FIELD_STOP).asText());
        }

        if (!childMap.containsKey(level)) {
            return;
        }

        for (String childLevel : childMap.get(level)) {

            if (!requestNode.has(childLevel) || !requestNode.get(childLevel).elements().hasNext()) {
                continue;
            }

            responseNode.putObject(childLevel);
            ObjectNode responseLevelNode = (ObjectNode) responseNode.get(childLevel);

            requestNode.get(childLevel).fields().forEachRemaining(entry -> {
                String id = entry.getKey();
                JsonNode requestChildNode = entry.getValue();
                responseLevelNode.putObject(id);
                fillResponse(childLevel, requestChildNode, (ObjectNode) responseLevelNode.get(id));
            });
        }
    }

    private static String magicId(String eidStr) {
        BigInteger magicNum = BigInteger.valueOf(2).pow(31).subtract(BigInteger.ONE);
        BigInteger eid = BigInteger.valueOf(Long.valueOf(eidStr)).add(BigInteger.valueOf(15));
        while (eid.compareTo(magicNum) > 0) {
            eid = eid.subtract(magicNum);
        }
        return String.valueOf(eid);
    }

    private static void copyField(JsonNode from, ObjectNode to, String field) {
        to.set(field, from.get(field));
    }
}
