package ru.yandex.direct.intapi.entity.callout.presentation;

import ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectTranslations;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;

import static ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectIds.Gen.AD_EXTENSION_ALREADY_EXISTS;
import static ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectIds.Gen.AD_EXTENSION_IS_DELETED;
import static ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectIds.Gen.AD_EXTENSION_IS_IN_USE;
import static ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectIds.Gen.CALLOUT_TEXT_IS_EMPTY;
import static ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectIds.Gen.DUPLICATE_CALLOUT_TEXTS;
import static ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectIds.Numbers.MAX_CLIENT_CALLOUTS;
import static ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectIds.Numbers.MAX_CLIENT_CALLOUTS_WITH_DELETED;
import static ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectIds.Strings.ALLOWED_SYMBOLS_CALLOUT_TEXT;
import static ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectIds.Strings.CALLOUT_TEXT_LENGTH_EXCEEDED;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.intapiDefect;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.paramIntapiDefect;

public class CalloutDefectPresentations {

    private CalloutDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> calloutPresentationRegistry() {
        CalloutDefectTranslations translations = CalloutDefectTranslations.INSTANCE;
        CommonDefectTranslations commonTranslations = CommonDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(MAX_CLIENT_CALLOUTS,
                        paramIntapiDefect(di -> translations.maxCalloutsOnClient(
                                di.getDefect().params().getMax())))
                .register(MAX_CLIENT_CALLOUTS_WITH_DELETED,
                        paramIntapiDefect(di -> translations
                                .maxCalloutsOnClientWithDeleted(di.getDefect().params().getMax())))
                .register(DUPLICATE_CALLOUT_TEXTS,
                        intapiDefect(translations.duplicateCalloutTexts()))
                .register(ALLOWED_SYMBOLS_CALLOUT_TEXT,
                        intapiDefect(translations.notAllowedSymbolsInCalloutText()))
                .register(AD_EXTENSION_ALREADY_EXISTS,
                        intapiDefect(translations.adExtensionAlreadyExists()))

                .register(AD_EXTENSION_IS_IN_USE,
                        intapiDefect(translations.adExtensionIsInUse()))
                .register(AD_EXTENSION_IS_DELETED,
                        intapiDefect(commonTranslations.objectAlreadyMarkedAsDeletedDetailed()))

                .register(CALLOUT_TEXT_IS_EMPTY,
                        intapiDefect(translations.emptyValue()))
                .register(CALLOUT_TEXT_LENGTH_EXCEEDED,
                        paramIntapiDefect(di -> translations.calloutTextLengthExceeded(
                                di.getValue().toString(),
                                di.getDefect().params().getMaxLength())))

                .build();
    }
}
