package ru.yandex.direct.intapi.entity.campaign.presentation;

import ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectTranslations;
import ru.yandex.direct.core.entity.campaign.service.validation.StrategyDefectIds;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;

import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.ContentLanguage.BAD_LANGUAGE;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.ARCHIVED_CAMPAIGN_MODIFICATION;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.BRAND_LIFT_CANT_BE_CHANGED;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.BRAND_LIFT_CAN_BE_ADDED_ONLY_TO_DRAFT_CAMPAIGN;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.BRAND_LIFT_EXPERIMENT_SEGMENTS_CANT_BE_CHANGED;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.BROAD_MATCH_DOESNT_MATCH_STRATEGY;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.CAMPAIGNS_PROMOTIONS_PERIODS_ARE_INTERSECTED;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.CAMPAIGN_ALREADY_ARCHIVED;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.CAMPAIGN_ALREADY_SUSPENDED;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.CAMPAIGN_IS_IN_SPECIAL_ARCHIVED_STATE;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.CAMPAIGN_MORE_THAN_ONCE_IN_REQUEST;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.CAMPAIGN_NOT_ARCHIVED;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.CAMPAIGN_NOT_FOUND;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.CAMPAIGN_NOT_SUSPENDED;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.CAMPAIGN_NO_WRITE_RIGHTS;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.CAMPAIGN_TYPE_NOT_SUPPORTED;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.CAMPAIGN_WITH_MONEY_ARCHIVING;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.CANT_ADD_OR_DELETE_METRIKA_COUNTERS_TO_PERFORMANCE_CAMPAIGN;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.CPM_BANNER_CAMPAIGN_DISABLED;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.DAY_BUDGET_IS_ONLY_USEFUL_FOR_MANUAL_STRATEGIES;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.DAY_BUDGET_NOT_SUPPORTED_WITH_STRATEGY;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.DAY_BUDGET_OVERRIDEN_BY_WALLET;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.DAY_BUDGET_SHOW_MODE_OVERRIDEN_BY_WALLET;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.INCONSISTENT_CAMPAIGN_TYPE;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.METRIKA_COUNTERS_UNSUPPORTED_CAMP_TYPE;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.METRIKA_COUNTER_IS_UNAVAILABLE;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.MINUS_KEYWORDS_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.NON_STOPPED_CAMPAIGN_ARCHIVING;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.NOT_ALLOWED_ATTRIBUTION_TYPE;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.OPERATOR_CANNOT_SET_ALLOWED_PAGE_IDS;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.OPERATOR_CANNOT_SET_CONTENT_LANGUAGE;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.OPERATOR_CANNOT_SET_DISALLOWED_PAGE_IDS;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.RELEVANT_KEYWORDS_USELESS_FOR_CHOSEN_STRATEGY;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.REQUIRE_SERVICING_WILL_BE_IGNORED;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.VIDEO_TYPE_NOT_SUPPORTED_WITH_STRATEGY;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Gen.WRONG_DISABLED_DOMAINS_LIMIT;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.IpAddresses.INVALID_IP_FORMAT;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.IpAddresses.IP_CANT_BE_FROM_INTERNAL_NETWORK;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.IpAddresses.IP_CANT_BE_FROM_PRIVATE_NETWORK;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.LongSubset.MUST_CONTAIN_METRIKA_COUNTERS;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Nums.MAX_ACTIVE_CAMPAIGNS_PROMOTIONS;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Nums.MAX_COUNT_OF_CAMPAIGNS_CREATED;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Nums.MAX_METRIKA_COUNTERS_LIST_SIZE;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Nums.TOO_MANY_DAY_BUDGET_DAILY_CHANGES;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Nums.UNARC_CAMPAIGNS_LIMIT_EXCEEDED;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Places.INVALID_DOMAIN_OR_SSP;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Places.UNKNOWN_SSP;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds.Subset.MUST_NOT_CONTAIN_DUPLICATED_STRINGS;
import static ru.yandex.direct.core.entity.campaign.service.validation.CopyCampaignDefects.Gen.ALREADY_IN_CAMPAIGN_QUEUE;
import static ru.yandex.direct.core.entity.campaign.service.validation.CopyCampaignDefects.Gen.ALREADY_IN_COPY_QUEUE;
import static ru.yandex.direct.core.entity.campaign.service.validation.CopyCampaignDefects.Gen.CANNOT_COPY_BANNERS_WITH_REJECTED_CREATIVES;
import static ru.yandex.direct.core.entity.campaign.service.validation.CopyCampaignDefects.Gen.CANNOT_COPY_CANVAS_CREATIVES_BETWEEN_CLIENTS;
import static ru.yandex.direct.core.entity.campaign.service.validation.CopyCampaignDefects.Gen.CANNOT_COPY_CPC_VIDEO_BANNERS_BETWEEN_CLIENTS;
import static ru.yandex.direct.core.entity.campaign.service.validation.CopyCampaignDefects.Gen.CANNOT_COPY_DYNAMIC_FEED_ADGROUPS_BETWEEN_CLIENTS;
import static ru.yandex.direct.core.entity.campaign.service.validation.CopyCampaignDefects.Gen.CANNOT_COPY_PERMALINKS_WITHOUT_ACCESS;
import static ru.yandex.direct.core.entity.campaign.service.validation.CopyCampaignDefects.Gen.FLAG_IS_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.campaign.service.validation.CopyCampaignDefects.Gen.MUST_BE_CLIENT;
import static ru.yandex.direct.core.entity.campaign.service.validation.CopyCampaignDefects.Gen.MUST_BE_SAME_SUB_CLIENT;
import static ru.yandex.direct.core.entity.campaign.service.validation.CopyCampaignDefects.Gen.SELECTOR_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.campaign.service.validation.CopyCampaignDefects.Gen.YND_FIXED_CURRENCY;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.intapiDefect;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.paramIntapiDefect;

public class CampaignDefectPresentations {

    private CampaignDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> campaignDefectPresentationRegistry() {
        CommonDefectTranslations translations = CommonDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(INCONSISTENT_CAMPAIGN_TYPE,
                        defaultIntapiDefect())
                .register(CAMPAIGN_TYPE_NOT_SUPPORTED,
                        defaultIntapiDefect())
                .register(ARCHIVED_CAMPAIGN_MODIFICATION,
                        intapiDefect(translations.cantEditArchivedCampaignDetailed()))
                .register(CAMPAIGN_NO_WRITE_RIGHTS,
                        intapiDefect(translations.noRightsCantWrite()))
                .register(CAMPAIGN_NOT_FOUND,
                        paramIntapiDefect(di -> translations.campaignNotFoundDetailed(
                                new Identity((long) di.getValue()))))
                .register(CAMPAIGN_ALREADY_SUSPENDED,
                        intapiDefect(translations.campaignAlreadySuspendedDetailed()))
                .register(CAMPAIGN_NOT_SUSPENDED,
                        intapiDefect(translations.campaignNotSuspendedDetailed()))
                .register(CAMPAIGN_WITH_MONEY_ARCHIVING,
                        intapiDefect(translations.campaignWithMoneyArchivingDetailed()))
                .register(MINUS_KEYWORDS_NOT_ALLOWED,
                        intapiDefect(translations.minusKeywordsAreNotAllowedForCampaign()))
                .register(WRONG_DISABLED_DOMAINS_LIMIT, intapiDefect(translations.wrongDisabledDomainsLimit()))
                .register(INVALID_DOMAIN_OR_SSP, defaultIntapiDefect())
                .register(MUST_NOT_CONTAIN_DUPLICATED_STRINGS, defaultIntapiDefect())
                .register(MUST_CONTAIN_METRIKA_COUNTERS, defaultIntapiDefect())
                .register(UNKNOWN_SSP, defaultIntapiDefect())
                .register(BAD_LANGUAGE, defaultIntapiDefect())
                .register(INVALID_IP_FORMAT, defaultIntapiDefect())
                .register(IP_CANT_BE_FROM_INTERNAL_NETWORK, defaultIntapiDefect())
                .register(IP_CANT_BE_FROM_PRIVATE_NETWORK, defaultIntapiDefect())
                .register(BROAD_MATCH_DOESNT_MATCH_STRATEGY, defaultIntapiDefect())
                .register(RELEVANT_KEYWORDS_USELESS_FOR_CHOSEN_STRATEGY, defaultIntapiDefect())
                .register(OPERATOR_CANNOT_SET_CONTENT_LANGUAGE, intapiDefect(translations.noRightsCantWrite()))
                .register(TOO_MANY_DAY_BUDGET_DAILY_CHANGES, defaultIntapiDefect())
                .register(MAX_COUNT_OF_CAMPAIGNS_CREATED, defaultIntapiDefect())
                .register(DAY_BUDGET_OVERRIDEN_BY_WALLET, defaultIntapiDefect())
                .register(DAY_BUDGET_SHOW_MODE_OVERRIDEN_BY_WALLET, defaultIntapiDefect())
                .register(DAY_BUDGET_NOT_SUPPORTED_WITH_STRATEGY, defaultIntapiDefect())
                .register(DAY_BUDGET_IS_ONLY_USEFUL_FOR_MANUAL_STRATEGIES, defaultIntapiDefect())
                .register(VIDEO_TYPE_NOT_SUPPORTED_WITH_STRATEGY, defaultIntapiDefect())
                .register(BRAND_LIFT_CANT_BE_CHANGED, defaultIntapiDefect())
                .register(BRAND_LIFT_EXPERIMENT_SEGMENTS_CANT_BE_CHANGED, defaultIntapiDefect())
                .register(BRAND_LIFT_CAN_BE_ADDED_ONLY_TO_DRAFT_CAMPAIGN, defaultIntapiDefect())
                .register(OPERATOR_CANNOT_SET_ALLOWED_PAGE_IDS, intapiDefect(translations.noRightsCantWrite()))
                .register(OPERATOR_CANNOT_SET_DISALLOWED_PAGE_IDS, intapiDefect(translations.noRightsCantWrite()))
                .register(ALREADY_IN_CAMPAIGN_QUEUE, defaultIntapiDefect())
                .register(ALREADY_IN_COPY_QUEUE, defaultIntapiDefect())
                .register(MUST_BE_CLIENT, defaultIntapiDefect())
                .register(MUST_BE_SAME_SUB_CLIENT, defaultIntapiDefect())
                .register(SELECTOR_NOT_ALLOWED, defaultIntapiDefect())
                .register(FLAG_IS_NOT_ALLOWED, defaultIntapiDefect())
                .register(CANNOT_COPY_DYNAMIC_FEED_ADGROUPS_BETWEEN_CLIENTS, defaultIntapiDefect())
                .register(CANNOT_COPY_BANNERS_WITH_REJECTED_CREATIVES, defaultIntapiDefect())
                .register(CANNOT_COPY_CANVAS_CREATIVES_BETWEEN_CLIENTS, defaultIntapiDefect())
                .register(CANNOT_COPY_CPC_VIDEO_BANNERS_BETWEEN_CLIENTS, defaultIntapiDefect())
                .register(CANNOT_COPY_PERMALINKS_WITHOUT_ACCESS, defaultIntapiDefect())
                .register(YND_FIXED_CURRENCY, defaultIntapiDefect())
                .register(REQUIRE_SERVICING_WILL_BE_IGNORED, defaultIntapiDefect())
                .register(NOT_ALLOWED_ATTRIBUTION_TYPE, defaultIntapiDefect())
                .register(NON_STOPPED_CAMPAIGN_ARCHIVING,
                        intapiDefect(translations.nonStoppedCampaignArchivingDetailed()))
                .register(CAMPAIGN_ALREADY_ARCHIVED,
                        intapiDefect(translations.campaignAlreadyArchivedDetailed()))
                .register(CAMPAIGN_NOT_ARCHIVED,
                        intapiDefect(translations.campaignNotArchivedDetailed()))
                .register(CAMPAIGN_IS_IN_SPECIAL_ARCHIVED_STATE,
                        paramIntapiDefect(di -> translations.campaignIsInSpecialArchivedState(
                                di.getValue().toString())))
                .register(UNARC_CAMPAIGNS_LIMIT_EXCEEDED,
                        paramIntapiDefect(di -> translations.unarcCampaignsLimitExceededDetailed(
                                new Identity(di.getDefect().params().getMax().longValue()))))
                .register(CAMPAIGNS_PROMOTIONS_PERIODS_ARE_INTERSECTED, defaultIntapiDefect())
                .register(CAMPAIGN_MORE_THAN_ONCE_IN_REQUEST, intapiDefect(translations.duplicatedCampaignId()))
                .register(MAX_ACTIVE_CAMPAIGNS_PROMOTIONS, defaultIntapiDefect())
                .register(CPM_BANNER_CAMPAIGN_DISABLED,
                        intapiDefect(translations.cpmBannerCampaignDisabled()))
                .build();
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect>
    campMetrikaCountersDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(CANT_ADD_OR_DELETE_METRIKA_COUNTERS_TO_PERFORMANCE_CAMPAIGN,
                        defaultIntapiDefect())
                .register(METRIKA_COUNTER_IS_UNAVAILABLE,
                        defaultIntapiDefect())
                .register(METRIKA_COUNTERS_UNSUPPORTED_CAMP_TYPE,
                        defaultIntapiDefect())
                .register(MAX_METRIKA_COUNTERS_LIST_SIZE,
                        defaultIntapiDefect())
                .build();
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> strategyDefectPresentationRegistry() {
        CampaignDefectTranslations translations = CampaignDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(StrategyDefectIds.Gen.WEEK_BUDGET_LESS_THAN,
                        intapiDefect(translations.weekBudgetLessThan()))
                .register(StrategyDefectIds.Gen.BID_LESS_THAN_AVG_BID,
                        intapiDefect(translations.bidLessThanAvgBid()))
                .register(StrategyDefectIds.Gen.AVG_BID_AND_BID_TOGETHER_PROHIBITED,
                        intapiDefect(translations.avgBidAndBidTogetherAreProhibited()))
                .register(StrategyDefectIds.Gen.INCORRECT_RESERVE_RETURN,
                        intapiDefect(translations.incorrectReserveReturn()))
                .register(StrategyDefectIds.Gen.CAMPAIGN_STRATEGY_INFO_IS_IGNORED_ON_CAMPAIGN_ADD,
                        intapiDefect(translations.campaignStrategyInfoIsIgnoredOnCampaignAdd()))
                .register(StrategyDefectIds.Gen.CAMPAIGN_STRATEGY_INFO_IS_IGNORED_ON_CAMPAIGN_UPDATE,
                        intapiDefect(translations.campaignStrategyInfoIsIgnoredOnCampaignUpdate()))
                .register(StrategyDefectIds.Gen.NEW_STRATEGY_HAS_BEEN_CREATED,
                        intapiDefect(translations.newStrategyHasBeenCreated()))
                .register(StrategyDefectIds.Gen.CAMPAIGN_NOT_IN_PACKAGE,
                        intapiDefect(translations.campaignNotInPackage()))
                .register(StrategyDefectIds.Gen.INCONSISTENT_STATE_STRATEGY_AND_STRATEGY_TYPE,
                        intapiDefect(translations.inconsistentStrategyToStrategyType()))
                .register(StrategyDefectIds.Gen.STRATEGY_INFO_MISSED,
                        intapiDefect(translations.strategyInfoMissed()))
                .register(StrategyDefectIds.Gen.CAMPAIGNS_WITH_DIFFERENT_TYPES_IN_ONE_PACKAGE,
                        intapiDefect(translations.campaignsWithDifferentTypesInOnePackage()))
                .register(StrategyDefectIds.Gen.INCONSISTENT_STATE_STRATEGY_TYPE_AND_CAMPAIGN_TYPE,
                        intapiDefect(translations.inconsistentStrategyToCampaignType()))
                .register(StrategyDefectIds.Gen.INCONSISTENT_STATE_STRATEGY_TYPE_AND_AD_GROUP_TYPES,
                        intapiDefect(translations.inconsistentStrategyToAdGroupTypes()))
                .register(StrategyDefectIds.Gen
                                .INCONSISTENT_STATE_STRATEGY_TYPE_AND_MOBILE_CAMPAIGN_WITHOUT_TRACKING_SYSTEM,
                        intapiDefect(translations.inconsistentStrategyToMobileCampaignWithoutTrackingSystem()))
                .register(StrategyDefectIds.Gen.UNABLE_TO_USE_CURRENT_MEANINGFUL_GOALS_FOR_OPTIMIZATION,
                        intapiDefect(translations.unableToUseCurrentMeaningfulGoalsForOptimization()))
                .register(StrategyDefectIds.Gen.NO_MEANINGFUL_GOAL_AVAILABLE_AFTER_COPY,
                        defaultIntapiDefect())
                .register(StrategyDefectIds.Gen.MEANINGFUL_GOALS_VALUES_FROM_METRIKA_NOT_SUPPORTED,
                        intapiDefect(translations.meaningfulGoalsValuesFromMetrikaNotSupported()))
                .register(StrategyDefectIds.Gen.MEANINGFUL_GOALS_VALUES_FROM_METRIKA_INCONSISTENT_STRATEGY,
                        intapiDefect(translations.meaningfulGoalsValuesFromMetrikaInconsistentStrategy()))
                .register(StrategyDefectIds.Gen.MEANINGFUL_GOALS_VALUES_FROM_METRIKA_ALLOW_ONLY_ALL_GOALS,
                        intapiDefect(translations.meaningfulGoalsValuesFromMetrikaAllowOnlyAllGoals()))
                .register(StrategyDefectIds.Gen.PAY_FOR_CONVERSION_NOT_SUPPORTED,
                        intapiDefect(translations.payForConversionNotSupported()))
                .register(StrategyDefectIds.Gen.AVG_CPA_IS_REQUIRED,
                        intapiDefect(translations.avgCpaIsRequired()))
                .register(StrategyDefectIds.Gen.PAY_FOR_CONVERSION_DOES_NOT_ALLOW_WALLET_DAY_BUDGET,
                        intapiDefect(translations.payForConversionDoesNotAllowWalletDayBudget()))
                .register(StrategyDefectIds.Num.STRATEGY_CHANGING_LIMIT_WAS_EXCEEDED,
                        intapiDefect(translations.strategyChangingLimitWasExceeded()))
                .register(StrategyDefectIds.Gen.PAY_FOR_CONVERSION_DOES_NOT_SUPPORT_BANNERS_WITHOUT_TURBO,
                        intapiDefect(translations.payForConversionDoesNotSupportBannersWithoutTurbo()))
                .register(StrategyDefectIds.Gen.PAY_FOR_CONVERSION_DOES_NOT_SUPPORT_SITELINKS_WITH_HREFS,
                        intapiDefect(translations.payForConversionDoesNotSupportSitelinksWithHrefs()))
                .register(StrategyDefectIds.Gen.PAY_FOR_CONVERSION_DOES_NOT_ALLOW_ALL_GOALS,
                        intapiDefect(translations.payForConversionDoesNotAllowAllGoals()))
                .register(StrategyDefectIds.Gen.STRATEGY_START_DATE_IS_BEFORE_CAMPAIGN_START_DATE,
                        defaultIntapiDefect())
                .register(StrategyDefectIds.Gen.STRATEGY_END_DATE_IS_AFTER_CAMPAIGN_END_DATE,
                        defaultIntapiDefect())
                .register(StrategyDefectIds.Num.STRATEGY_PERIOD_DAYS_COUNT_LESS_THAN_MIN,
                        paramIntapiDefect(di -> CommonDefectTranslations.INSTANCE.invalidValueDetailed(di.getValue())))
                .register(StrategyDefectIds.Num.STRATEGY_PERIOD_DAYS_COUNT_GREATER_THAN_MAX,
                        paramIntapiDefect(di -> CommonDefectTranslations.INSTANCE.invalidValueDetailed(di.getValue())))
                .register(StrategyDefectIds.Gen.INCORRECT_SET_OF_MOBILE_GOALS,
                        intapiDefect(translations.incorrectSetOfMobileGoals()))
                .register(StrategyDefectIds.Gen.ALL_GOALS_OPTIMIZATION_PROHIBITED,
                        intapiDefect(translations.allGoalsOptimizationProhibited()))
                .register(StrategyDefectIds.Gen.WEEKLY_BUDGET_IS_NOT_SUPPORTED,
                        intapiDefect(translations.weeklyBudgetIsNotSupported()))
                .register(StrategyDefectIds.Gen.LINKING_NON_PUBLIC_STRATEGY_TO_SEVERAL_CAMPAIGNS,
                        intapiDefect(translations.linkingNonPublicStrategyToSeveralCampaigns()))
                .register(StrategyDefectIds.Gen.UNAVAILABLE_STRATEGY_TYPE_FOR_PUBLICATION,
                        intapiDefect(translations.unavailableStrategyTypeForPublication()))
                .register(StrategyDefectIds.Gen.CHANGE_PUBLIC_STRATEGY_TO_PRIVATE,
                        intapiDefect(translations.changePublicStrategyToPrivate()))
                .register(StrategyDefectIds.Gen.PUBLIC_STRATEGY_NOT_SUPPORTED_FOR_CLIENTS_WITHOUT_WALLET,
                        intapiDefect(translations.publicStrategyNotSupportedForClientsWithoutWallet()))
                .register(StrategyDefectIds.Gen.FLAT_CPC_STRATEGY_NOT_SUPPORTED,
                        intapiDefect(translations.flatCpcStrategyNotSupported()))
                .register(StrategyDefectIds.Gen.ARCHIVED_STRATEGY_MODIFICATION,
                        intapiDefect(translations.archivedStrategyModificationNotAllowed()))
                .register(StrategyDefectIds.Gen.STRATEGY_ARCHIVING_NOT_ALLOWED,
                        intapiDefect(CampaignDefectTranslations.INSTANCE.strategyArchivingNotAllowed()))
                .register(StrategyDefectIds.Gen.WEEKLY_BUDGET_IS_MANDATORY,
                        intapiDefect(translations.weeklyBudgetIsMandatory()))
                .register(StrategyDefectIds.NumParameters.STRATEGIES_NUMBER_LIMIT_EXCEEDED,
                        intapiDefect(translations.strategiesNumberLimitExceeded()))
                .register(StrategyDefectIds.NumParameters.UNARCHIVED_STRATEGIES_NUMBER_LIMIT_EXCEEDED,
                        intapiDefect(translations.unarchivedStrategiesNumberLimitExceeded()))
                .register(StrategyDefectIds.Num.TOO_MUCH_CAMPAIGNS_LINKED_TO_STRATEGY,
                        intapiDefect(translations.tooMuchCampaignsLinkedToStrategy()))
                .register(StrategyDefectIds.Gen.STRATEGY_NOT_FOUND,
                        intapiDefect(translations.strategyNotFound()))

                .build();
    }
}
