package ru.yandex.direct.intapi.entity.campaigns.impressionrate.model;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.intapi.validation.model.IntapiValidationResponse;

public class CampaignImpressionRateGetResponse extends IntapiValidationResponse {
    @JsonInclude(JsonInclude.Include.ALWAYS)
    @JsonProperty("rate_count")
    private final Integer rateCount;

    @JsonInclude(JsonInclude.Include.ALWAYS)
    @JsonProperty("rate_interval_days")
    private final Integer rateIntervalDays;

    public CampaignImpressionRateGetResponse(IntapiValidationResponse intapiValidationResponse,
                                             @Nullable Integer rateCount,
                                             @Nullable Integer rateIntervalDays) {
        super(intapiValidationResponse.validationResult());
        this.rateCount = rateCount;
        this.rateIntervalDays = rateIntervalDays;
    }

    public Integer getRateCount() {
        return rateCount;
    }

    public Integer getRateIntervalDays() {
        return rateIntervalDays;
    }
}
