package ru.yandex.direct.intapi.entity.campaigns.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY,
        getterVisibility = JsonAutoDetect.Visibility.NONE,
        setterVisibility = JsonAutoDetect.Visibility.NONE,
        creatorVisibility = JsonAutoDetect.Visibility.NONE
)
public class CampaignsAddZenRequest {
    @JsonProperty(value = "ClientID", required = true)
    @ApiModelProperty(value = "Идентификатор клиента", required = true, example = "456789")
    private long clientId;

    public long getClientId() {
        return clientId;
    }

    public CampaignsAddZenRequest withClientId(long clientId) {
        this.clientId = clientId;
        return this;
    }
}
