package ru.yandex.direct.intapi.entity.campaigns.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY,
        getterVisibility = JsonAutoDetect.Visibility.NONE,
        setterVisibility = JsonAutoDetect.Visibility.NONE,
        creatorVisibility = JsonAutoDetect.Visibility.NONE
)
public class CampaignsAddZenResponse {
    @JsonProperty(value = "ExportID")
    @ApiModelProperty(value = "Номер кампании в Директе", example = "7123456")
    private Long campaignId;

    @JsonProperty(value = "Error")
    @ApiModelProperty(value = "Ошибка", example = "NO_WALLET")
    private String error;

    @JsonProperty(value = "ErrorDetails")
    @ApiModelProperty(value = "Пояснение к ошибке", example = "У клиента (или клиента и агентства) не заведён кошелёк")
    private String errorDetails;

    public Long getCampaignId() {
        return campaignId;
    }

    public CampaignsAddZenResponse withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public void setCampaignId(Long campaignId) {
        this.campaignId = campaignId;
    }

    public String getError() {
        return error;
    }

    public CampaignsAddZenResponse withError(String error) {
        this.error = error;
        return this;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getErrorDetails() {
        return errorDetails;
    }

    public CampaignsAddZenResponse withErrorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    public void setErrorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
    }
}
