package ru.yandex.direct.intapi.entity.client.presentation;

import ru.yandex.direct.core.entity.client.service.validation.ClientDefectTranslations;
import ru.yandex.direct.core.entity.client.service.validation.ClientDefects;
import ru.yandex.direct.grid.processing.service.validation.GridDefectIds;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;

import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.intapiDefect;

public class ClientDefectPresentations {
    private ClientDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> clientDefectPresentationRegistry() {

        ClientDefectTranslations clientDefectTranslations = ClientDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()

                .register(ClientDefects.Gen.MUST_NOT_BE_FREELANCER,
                        intapiDefect(clientDefectTranslations.mustNotBeFreelancer()))

                .register(ClientDefects.Gen.NOT_APPROPRIATE_ROLE,
                        intapiDefect(clientDefectTranslations.notAppropriateRole()))

                .register(GridDefectIds.Str.INVALID_CLIENT_MEASURER, defaultIntapiDefect())
                .build();
    }

}
