package ru.yandex.direct.intapi.entity.clientdata;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.direct.core.entity.client.model.ClientWithUsers;
import ru.yandex.direct.core.entity.user.model.User;


@ApiModel
public class ClientData {
    private String name;

    @ApiModel
    private static class ShortUser {
        private String login;
        private String fio;
        private boolean chief;

        ShortUser(User user) {
            this.login = user.getLogin();
            this.fio = user.getFio();
            this.chief = user.getUid().equals(user.getChiefUid());
        }

        @ApiModelProperty(value = "логин пользователя", required = true, name = "login")
        public String getLogin() {
            return login;
        }

        public void setLogin(String login) {
            this.login = login;
        }

        @ApiModelProperty(value = "ФИО пользователя", required = true, name = "FIO")
        public String getFio() {
            return fio;
        }

        public void setFio(String fio) {
            this.fio = fio;
        }

        @ApiModelProperty(value = "флаг является ли главным пользователем", required = true, name = "markChief")
        public boolean isChief() {
            return chief;
        }

        public void setChief(boolean chief) {
            this.chief = chief;
        }
    }

    @JsonProperty("uids")
    private Map<Long, ShortUser> users;

    public ClientData(String name, Map<Long, ShortUser> users) {
        this.name = name;
        this.users = users;
    }

    public ClientData(ClientWithUsers client) {
        this.name = client.getName();
        this.users = new HashMap<>();
        client.getUsers().forEach(u -> this.users.put(u.getUid(), new ShortUser(u)));
    }

    @ApiModelProperty(
            value = "имя клиента",
            required = true,
            name = "name"
    )
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(
            value = "список пользователей с проинициализированными полями",
            required = true,
            name = "uids"
    )
    public Map<Long, ShortUser> getUsers() {
        return users;
    }

    public void setUsers(Map<Long, ShortUser> users) {
        this.users = users;
    }
}
