package ru.yandex.direct.intapi.entity.clientdata;

import java.util.List;
import java.util.Map;

import javax.ws.rs.GET;
import javax.ws.rs.core.MediaType;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.direct.core.entity.client.model.ClientWithUsers;
import ru.yandex.direct.core.entity.client.service.ClientService;
import ru.yandex.direct.intapi.ErrorResponse;
import ru.yandex.direct.rbac.RbacService;
import ru.yandex.direct.tvm.AllowServices;

import static java.util.stream.Collectors.toMap;
import static ru.yandex.direct.tvm.TvmService.CRM_PROD;
import static ru.yandex.direct.tvm.TvmService.CRM_TEST;
import static ru.yandex.direct.tvm.TvmService.DIRECT_DEVELOPER;
import static ru.yandex.direct.tvm.TvmService.LPC_SWITCHCONSTRUCTOR_PROD;
import static ru.yandex.direct.tvm.TvmService.LPC_SWITCHCONSTRUCTOR_TEST;

@RestController
@RequestMapping({"clients"})
@Api(value = "API для получения данных по клиенту")
public class ClientDataController {
    private static final Logger logger = LoggerFactory.getLogger(ClientDataController.class);

    private final ClientService clientService;
    private final RbacService rbacService;

    @Autowired
    public ClientDataController(ClientService clientService, RbacService rbacService) {
        this.clientService = clientService;
        this.rbacService = rbacService;
    }

    /**
     * @param clientIds
     * @return {@link ClientData}
     */
    @GET
    @ApiOperation(
            value = "получение информации по клиенту",
            nickname = "clientdata",
            httpMethod = "GET"
    )
    @ApiResponses(
            @ApiResponse(code = 400, message = "Не найден клиент",
                    response = ErrorResponse.class)
    )
    @RequestMapping(path = "get_by_ClientID",
            method = RequestMethod.GET,
            produces = MediaType.APPLICATION_JSON
    )
    @AllowServices(production = {LPC_SWITCHCONSTRUCTOR_PROD, CRM_PROD},
            testing = {LPC_SWITCHCONSTRUCTOR_TEST, CRM_TEST, DIRECT_DEVELOPER})
    public Map<Long, ClientData> getClientdataByIds(
            @ApiParam(value = "список id клиентов", required = true)
            @RequestParam(value = "client_id") List<Long> clientIds) {
        logger.debug("process request get_clientdata_by_ids()");

        return clientService.massGetClientWithUsers(clientIds).stream()
                .collect(toMap(ClientWithUsers::getId, ClientData::new));
    }
}
