package ru.yandex.direct.intapi.entity.clientdata;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class ClientWithRole {
    private String clientName;
    private Long clientId;
    private String role;

    public String getClientName() {
        return clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public String getRole() {
        return role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public ClientWithRole withClientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    public ClientWithRole withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public ClientWithRole withRole(String role) {
        this.role = role;
        return this;
    }
}
