package ru.yandex.direct.intapi.entity.clients.model;

import java.util.Objects;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class CheckClientStateRequest {
    @JsonProperty("login")
    @Nullable
    private final String login;

    @JsonProperty("uid")
    @Nullable
    private final Long uid;

    @JsonProperty("with_balance")
    @Nullable
    private final Boolean withBalance;

    @JsonCreator
    public CheckClientStateRequest(
            @Nullable @JsonProperty("login") String login,
            @Nullable @JsonProperty("uid") Long uid,
            @Nullable @JsonProperty("with_balance") Boolean withBalance) {
        this.login = login;
        this.uid = uid;
        this.withBalance = withBalance;
    }

    @Nullable
    public String getLogin() {
        return login;
    }

    @Nullable
    public Long getUid() {
        return uid;
    }

    @Nullable
    public Boolean getWithBalance() {
        return withBalance;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CheckClientStateRequest that = (CheckClientStateRequest) o;
        return Objects.equals(login, that.login) && Objects.equals(uid, that.uid) && Objects.equals(withBalance,
                that.withBalance);
    }

    @Override
    public int hashCode() {
        return Objects.hash(login, uid, withBalance);
    }

    @Override
    public String toString() {
        return "CheckClientStateRequest{" +
                "login='" + login + '\'' +
                ", uid=" + uid + ", withBalance=" + withBalance +
                '}';
    }
}
