package ru.yandex.direct.intapi.entity.clients.model;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.intapi.validation.model.IntapiSuccessResponse;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class CheckClientStateResponse extends IntapiSuccessResponse {
    @JsonProperty("client_state")
    private final ClientState clientState;

    @JsonProperty("login_in_direct")
    private final String loginInDirect;

    @JsonProperty("client_role")
    private final ClientRole clientRole;

    @JsonProperty("has_shared_wallet")
    private final Boolean hasSharedWallet;

    @JsonProperty("balance")
    private final BigDecimal balance;

    @JsonProperty("currency_code")
    private final CurrencyCode currencyCode;

    @JsonProperty("can_not_be_created_reason")
    private final String canNotBeCreatedReason;

    public CheckClientStateResponse(ClientState clientState, String canNotBeCreatedReason) {
        this(clientState, null, null, null, null, null, canNotBeCreatedReason);
    }

    public CheckClientStateResponse(ClientState clientState, String loginInDirect,
                                    ClientRole clientRole, Boolean hasSharedWallet,
                                    BigDecimal balance, CurrencyCode currencyCode) {
        this(clientState, loginInDirect, clientRole, hasSharedWallet, balance, currencyCode, null);
    }

    public CheckClientStateResponse(
            ClientState clientState, String loginInDirect,
            ClientRole clientRole, Boolean hasSharedWallet,
            BigDecimal balance, CurrencyCode currencyCode,
            String canNotBeCreatedReason) {
        this.clientState = clientState;
        this.loginInDirect = loginInDirect;
        this.clientRole = clientRole;
        this.hasSharedWallet = hasSharedWallet;
        this.balance = balance;
        this.currencyCode = currencyCode;
        this.canNotBeCreatedReason = canNotBeCreatedReason;
    }

    public ClientState getClientState() {
        return clientState;
    }

    public String getLoginInDirect() {
        return loginInDirect;
    }

    public ClientRole getClientRole() {
        return clientRole;
    }

    public Boolean getHasSharedWallet() {
        return hasSharedWallet;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public CurrencyCode getCurrencyCode() {
        return currencyCode;
    }

    public String getCanNotBeCreatedReason() {
        return canNotBeCreatedReason;
    }
}
